/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.XPackFile;
import com.izforge.izpack.event.InstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.MultiVolumeInstaller;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.io.FileSpanningInputStream;
import com.izforge.izpack.io.VolumeNotFoundException;
import com.izforge.izpack.panels.NextMediaDialog;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;

public class MultiVolumeUnpacker
implements IUnpacker {
    private AutomatedInstallData idata;
    private AbstractUIProgressHandler handler;
    private UninstallData udata;
    private VariableSubstitutor vs;
    private static HashMap instances = new HashMap();
    private File absolute_installpath;
    private LocaleDatabase langpack = null;
    private static boolean interruptDesired = false;
    private static boolean discardInterrupt = false;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    public static final String ALIVE = "alive";
    public static final String INTERRUPT = "doInterrupt";
    public static final String INTERRUPTED = "interruppted";
    private boolean result = true;

    public MultiVolumeUnpacker(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        try {
            String resource = "packsLang.xml_" + idata.localeISO3;
            this.langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(resource));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.idata = idata;
        this.handler = handler;
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getRunningInstances() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            return (HashMap)instances.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToInstances() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            instances.put(this, ALIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromInstances() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            instances.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInterruptAll() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Iterator iter = instances.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!instances.get(key).equals(ALIVE)) continue;
                instances.put(key, INTERRUPT);
            }
            MultiVolumeUnpacker.setInterruptDesired(true);
        }
    }

    public static boolean interruptAll(long waitTime) {
        long t0 = System.currentTimeMillis();
        if (MultiVolumeUnpacker.isDiscardInterrupt()) {
            return false;
        }
        MultiVolumeUnpacker.setInterruptAll();
        while (!MultiVolumeUnpacker.isInterruptReady()) {
            if (System.currentTimeMillis() - t0 > waitTime) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterruptReady() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Iterator iter = instances.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (instances.get(key).equals(INTERRUPTED)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performInterrupted() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Object doIt = instances.get(this);
            if (doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED))) {
                instances.put(this, INTERRUPTED);
                this.result = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldInterrupt() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Object doIt = instances.get(this);
            return doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED));
            {
            }
        }
    }

    protected File enterNextMediaMessage(String volumename) {
        Debug.trace("Enter next media: " + volumename);
        StackTraceElement[] el = new Exception().getStackTrace();
        for (int i = 0; i < el.length; ++i) {
            StackTraceElement element = el[i];
            Debug.trace(element.toString());
        }
        File nextvolume = new File(volumename);
        NextMediaDialog nmd = null;
        while (!nextvolume.exists()) {
            if (this.handler != null && this.handler instanceof IzPanel) {
                InstallerFrame installframe = ((IzPanel)((Object)this.handler)).getInstallerFrame();
                nmd = new NextMediaDialog((Frame)installframe, this.idata, volumename);
            } else {
                nmd = new NextMediaDialog(null, this.idata, volumename);
            }
            nmd.setVisible(true);
            String nextmediainput = nmd.getNextMedia();
            if (nextmediainput != null) {
                nextvolume = new File(nextmediainput);
                continue;
            }
            Debug.trace("Input from NextMediaDialog was null");
            nextvolume = new File(volumename);
        }
        return nextvolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.addToInstances();
        try {
            FileOutputStream out = null;
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updatechecks = new ArrayList<UpdateCheck>();
            List packs = this.idata.selectedPacks;
            int npacks = packs.size();
            Debug.trace("Unpacker starting");
            this.handler.startAction("Unpacking", npacks);
            this.udata = UninstallData.getInstance();
            List[] customActions = this.getCustomActions();
            this.informListeners(customActions, 7, this.idata, new Integer(npacks), this.handler);
            packs = this.idata.selectedPacks;
            npacks = packs.size();
            if (npacks == 0) {
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(customActions, 8, this.idata, this.handler, null);
                if (this.performInterrupted()) {
                    return;
                }
                this.handler.stopAction();
                return;
            }
            InputStream in = MultiVolumeUnpacker.class.getResourceAsStream("/volumes.info");
            ObjectInputStream metadataobj = new ObjectInputStream(in);
            int volumes = metadataobj.readInt();
            String volumename = metadataobj.readUTF();
            Debug.trace("Reading from " + volumes + " volumes with basename " + volumename + " ");
            metadataobj.close();
            String mediadirectory = MultiVolumeInstaller.getMediadirectory();
            if (mediadirectory == null || mediadirectory.length() <= 0) {
                Debug.trace("Mediadirectory wasn't set.");
                mediadirectory = System.getProperty("java.io.tmpdir");
            }
            Debug.trace("Using mediadirectory = " + mediadirectory);
            File volume = new File(mediadirectory + File.separator + volumename);
            if (!volume.exists()) {
                volume = this.enterNextMediaMessage(volume.getAbsolutePath());
            }
            FileSpanningInputStream fin = new FileSpanningInputStream(volume, volumes);
            for (int i = 0; i < npacks; ++i) {
                String name;
                int n = this.idata.allPacks.indexOf(packs.get(i));
                in = (class$com$izforge$izpack$installer$MultiVolumeUnpacker == null ? MultiVolumeUnpacker.class$("com.izforge.izpack.installer.MultiVolumeUnpacker") : class$com$izforge$izpack$installer$MultiVolumeUnpacker).getResourceAsStream("/packs/pack" + n);
                this.informListeners(customActions, 5, packs.get(i), new Integer(npacks), this.handler);
                ObjectInputStream objIn = new ObjectInputStream(in);
                int nfiles = objIn.readInt();
                Pack pack = (Pack)packs.get(i);
                String stepname = pack.name;
                if (this.langpack != null && pack.id != null && !"".equals(pack.id) && (name = this.langpack.getString(pack.id)) != null && !"".equals(name)) {
                    stepname = name;
                }
                this.handler.nextStep(stepname, i + 1, nfiles);
                for (int j = 0; j < nfiles; ++j) {
                    XPackFile pf = (XPackFile)objIn.readObject();
                    if (OsConstraint.oneMatchesCurrentSystem(pf.osConstraints())) {
                        File pathFile;
                        String path = IoHelper.translatePath(pf.getTargetPath(), this.vs);
                        File dest = pathFile = new File(path);
                        if (!pf.isDirectory()) {
                            dest = pathFile.getParentFile();
                        }
                        if (!dest.exists()) {
                            List fileListeners = customActions[customActions.length - 1];
                            if (fileListeners != null && fileListeners.size() > 0) {
                                this.mkDirsWithEnhancement(dest, pf, customActions);
                            } else if (!dest.mkdirs()) {
                                this.handler.emitError("Error creating directories", "Could not create directory\n" + dest.getPath());
                                this.handler.stopAction();
                                this.result = false;
                                return;
                            }
                        }
                        if (pf.isDirectory()) continue;
                        this.informListeners(customActions, 1, pathFile, pf, null);
                        this.udata.addFile(path);
                        this.handler.progress(j, path);
                        if (pathFile.exists() && pf.override() != 1) {
                            boolean overwritefile = false;
                            if (pf.override() != 0) {
                                if (pf.override() == 1) {
                                    overwritefile = true;
                                } else if (pf.override() == 4) {
                                    overwritefile = pathFile.lastModified() < pf.lastModified();
                                } else {
                                    int answer;
                                    int def_choice = -1;
                                    if (pf.override() == 2) {
                                        def_choice = 49;
                                    }
                                    if (pf.override() == 3) {
                                        def_choice = 47;
                                    }
                                    boolean bl = overwritefile = (answer = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + " - " + pathFile.getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + pathFile.getAbsolutePath(), 37, def_choice)) == 47;
                                }
                            }
                            if (!overwritefile) {
                                if (pf.isBackReference() || ((Pack)packs.get((int)i)).loose) continue;
                                continue;
                            }
                        }
                        out = new FileOutputStream(pathFile);
                        byte[] buffer = new byte[5120];
                        long bytesCopied = 0L;
                        InputStream pis = fin;
                        if (((Pack)packs.get((int)i)).loose) {
                            pis = new FileInputStream(pf.sourcePath);
                        }
                        long fileposition = pf.getArchivefileposition();
                        while (fin.getFilepointer() < fileposition) {
                            Debug.trace("Skipping bytes to get to file " + pathFile.getName() + " (" + fin.getFilepointer() + "<" + fileposition + ") target is: " + (fileposition - fin.getFilepointer()));
                            try {
                                fin.skip(fileposition - fin.getFilepointer());
                                break;
                            }
                            catch (VolumeNotFoundException vnfe) {
                                File nextmedia = this.enterNextMediaMessage(vnfe.getVolumename());
                                fin.setVolumename(nextmedia.getAbsolutePath());
                            }
                        }
                        if (fin.getFilepointer() > fileposition) {
                            Debug.trace("Error, can't access file in pack.");
                        }
                        while (bytesCopied < pf.length()) {
                            block65: {
                                if (!this.performInterrupted()) break block65;
                                out.close();
                                if (pis != objIn) {
                                    pis.close();
                                }
                                return;
                            }
                            try {
                                int maxBytes = (int)Math.min(pf.length() - bytesCopied, (long)buffer.length);
                                int bytesInBuffer = pis.read(buffer, 0, maxBytes);
                                if (bytesInBuffer == -1) {
                                    Debug.trace("Unexpected end of stream (installer corrupted?)");
                                    throw new IOException("Unexpected end of stream (installer corrupted?)");
                                }
                                out.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            catch (VolumeNotFoundException vnfe) {
                                File nextmedia = this.enterNextMediaMessage(vnfe.getVolumename());
                                fin.setVolumename(nextmedia.getAbsolutePath());
                            }
                        }
                        out.close();
                        if (pf.lastModified() >= 0L) {
                            pathFile.setLastModified(pf.lastModified());
                        }
                        this.informListeners(customActions, 2, pathFile, pf, null);
                        continue;
                    }
                    if (pf.isBackReference()) continue;
                }
                int numParsables = objIn.readInt();
                Debug.trace("Looking for parsables");
                for (int k = 0; k < numParsables; ++k) {
                    ParsableFile pf = null;
                    while (true) {
                        File nextmedia;
                        try {
                            pf = (ParsableFile)objIn.readObject();
                        }
                        catch (VolumeNotFoundException vnfe) {
                            nextmedia = this.enterNextMediaMessage(vnfe.getVolumename());
                            fin.setVolumename(nextmedia.getAbsolutePath());
                            continue;
                        }
                        catch (EOFException eofe) {
                            nextmedia = this.enterNextMediaMessage("");
                            fin.setVolumename(nextmedia.getAbsolutePath());
                            continue;
                        }
                        break;
                    }
                    pf.path = IoHelper.translatePath(pf.path, this.vs);
                    Debug.trace("Found parsable: " + pf.path);
                    parsables.add(pf);
                }
                int numExecutables = objIn.readInt();
                Debug.trace("Looking for executables...");
                for (int k = 0; k < numExecutables; ++k) {
                    ExecutableFile ef = (ExecutableFile)objIn.readObject();
                    ef.path = IoHelper.translatePath(ef.path, this.vs);
                    if (null != ef.argList && !ef.argList.isEmpty()) {
                        String arg = null;
                        for (int j = 0; j < ef.argList.size(); ++j) {
                            arg = (String)ef.argList.get(j);
                            arg = IoHelper.translatePath(arg, this.vs);
                            ef.argList.set(j, arg);
                        }
                    }
                    Debug.trace("Found executable: " + ef.path);
                    executables.add(ef);
                    if (ef.executionStage != 2) continue;
                    this.udata.addExecutable(ef);
                }
                this.handleAdditionalUninstallData(this.udata, customActions);
                int numUpdateChecks = objIn.readInt();
                Debug.trace("Looking for updatechecks");
                for (int k = 0; k < numUpdateChecks; ++k) {
                    UpdateCheck uc = (UpdateCheck)objIn.readObject();
                    Debug.trace("found updatecheck");
                    updatechecks.add(uc);
                }
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(customActions, 6, packs.get(i), new Integer(i), this.handler);
            }
            Debug.trace("Trying to parse files");
            ScriptParser parser = new ScriptParser(parsables, this.vs);
            parser.parseFiles();
            Debug.trace("parsed files");
            if (this.performInterrupted()) {
                return;
            }
            Debug.trace("Trying to execute files");
            FileExecutor executor = new FileExecutor(executables);
            if (executor.executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
                this.result = false;
                Debug.trace("File execution failed");
            }
            if (this.performInterrupted()) {
                return;
            }
            Debug.trace("Create uninstaller");
            this.putUninstaller();
            Debug.trace("Uninstaller created");
            Debug.trace("Perform updateChecks");
            this.performUpdateChecks(updatechecks);
            Debug.trace("updatechecks performed.");
            if (this.performInterrupted()) {
                return;
            }
            this.informListeners(customActions, 8, this.idata, this.handler, null);
            if (this.performInterrupted()) {
                return;
            }
            this.writeConfigInformation();
            this.handler.stopAction();
            Debug.trace("Installation complete");
        }
        catch (Exception err) {
            this.handler.stopAction();
            this.handler.emitError("An error occured", err.toString());
            err.printStackTrace();
            Debug.trace("Error while installing: " + err.toString());
            this.result = false;
        }
        finally {
            this.removeFromInstances();
        }
    }

    protected void writeConfigInformation() {
        Properties installerproperties = this.idata.getVariables();
        Enumeration<Object> installerpropertieskeys = installerproperties.keys();
        try {
            String installpath = this.idata.getVariable("INSTALL_PATH");
            PrintWriter pw = new PrintWriter(new FileOutputStream(installpath + File.separator + "installer.properties"));
            pw.println("# Installer properties, written by MultiVolumeUnpacker.");
            while (installerpropertieskeys.hasMoreElements()) {
                String key = (String)installerpropertieskeys.nextElement();
                if (key.startsWith("SYSTEM_") || key.startsWith("password_")) continue;
                pw.println(key + "=" + installerproperties.getProperty(key));
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            Debug.trace("Error while writing config information in MultiVolumeUnpacker: " + e.getMessage());
        }
    }

    public boolean getResult() {
        return this.result;
    }

    private void performUpdateChecks(ArrayList updatechecks) {
        File f;
        ArrayList include_patterns = new ArrayList();
        ArrayList exclude_patterns = new ArrayList();
        RECompiler recompiler = new RECompiler();
        this.absolute_installpath = new File(this.idata.getInstallPath()).getAbsoluteFile();
        Iterator iter = updatechecks.iterator();
        while (iter.hasNext()) {
            UpdateCheck uc = (UpdateCheck)iter.next();
            if (uc.includesList != null) {
                include_patterns.addAll(this.preparePatterns(uc.includesList, recompiler));
            }
            if (uc.excludesList == null) continue;
            exclude_patterns.addAll(this.preparePatterns(uc.excludesList, recompiler));
        }
        if (include_patterns.size() == 0) {
            return;
        }
        TreeSet<String> installed_files = new TreeSet<String>();
        Iterator if_it = this.udata.getFilesList().iterator();
        while (if_it.hasNext()) {
            String fname = (String)if_it.next();
            f = new File(fname);
            if (!f.isAbsolute()) {
                f = new File(this.absolute_installpath, fname);
            }
            installed_files.add(f.getAbsolutePath());
        }
        Stack<File> scanstack = new Stack<File>();
        ArrayList<File> files_to_delete = new ArrayList<File>();
        try {
            scanstack.add(this.absolute_installpath);
            while (!scanstack.empty()) {
                f = (File)scanstack.pop();
                File[] files = f.listFiles();
                if (files == null) {
                    throw new IOException(f.getPath() + "is not a directory!");
                }
                for (int i = 0; i < files.length; ++i) {
                    File newf = files[i];
                    String newfname = newf.getPath();
                    if (installed_files.contains(newfname)) continue;
                    if (this.fileMatchesOnePattern(newfname, include_patterns) && !this.fileMatchesOnePattern(newfname, exclude_patterns)) {
                        files_to_delete.add(newf);
                    }
                    if (!newf.isDirectory()) continue;
                    scanstack.push(newf);
                }
            }
        }
        catch (IOException e) {
            this.handler.emitError("error while performing update checks", e.toString());
        }
        Iterator f_it = files_to_delete.iterator();
        while (f_it.hasNext()) {
            File f2 = (File)f_it.next();
            if (f2.isDirectory()) continue;
            this.handler.emitNotification("deleting " + f2.getPath());
            f2.delete();
        }
    }

    private boolean fileMatchesOnePattern(String filename, ArrayList patterns) {
        Iterator inc_it = patterns.iterator();
        while (inc_it.hasNext()) {
            RE pattern = (RE)inc_it.next();
            if (!pattern.match(filename)) continue;
            return true;
        }
        return false;
    }

    private List preparePatterns(ArrayList list, RECompiler recompiler) {
        ArrayList<RE> result = new ArrayList<RE>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (element == null || element.length() <= 0) continue;
            File f = new File(element = this.vs.substitute(element, "plain"));
            if (!f.isAbsolute()) {
                element = new File(this.absolute_installpath, element).toString();
            }
            StringBuffer element_re = new StringBuffer();
            int lookahead = -1;
            int pos = 0;
            block8: while (pos < element.length()) {
                char c;
                if (lookahead != -1) {
                    c = (char)lookahead;
                    lookahead = -1;
                } else {
                    c = element.charAt(pos++);
                }
                switch (c) {
                    case '/': {
                        element_re.append(File.separator);
                        continue block8;
                    }
                    case '.': 
                    case '\\': {
                        element_re.append("\\");
                        element_re.append(c);
                        continue block8;
                    }
                    case '*': {
                        if (pos == element.length()) {
                            element_re.append("[^").append(File.separator).append("]*");
                            continue block8;
                        }
                        if ((lookahead = (int)element.charAt(pos++)) == 42) {
                            element_re.append(".*");
                            lookahead = -1;
                            continue block8;
                        }
                        element_re.append("[^").append(File.separator).append("]*");
                        continue block8;
                    }
                }
                element_re.append(c);
            }
            element_re.append('$');
            try {
                result.add(new RE(recompiler.compile(element_re.toString())));
            }
            catch (RESyntaxException e) {
                this.handler.emitNotification("internal error: pattern \"" + element + "\" produced invalid RE \"" + f.getPath() + "\"");
            }
        }
        return result;
    }

    private void putUninstaller() throws Exception {
        ZipOutputStream outJar;
        InputStream[] in = new InputStream[2];
        in[0] = MultiVolumeUnpacker.class.getResourceAsStream("/res/IzPack.uninstaller");
        if (in[0] == null) {
            return;
        }
        in[1] = MultiVolumeUnpacker.class.getResourceAsStream("/res/IzPack.uninstaller-ext");
        String dest = IoHelper.translatePath("$INSTALL_PATH", this.vs) + File.separator + "Uninstaller";
        String jar = dest + File.separator + this.idata.info.getUninstallerName();
        File pathMaker = new File(dest);
        pathMaker.mkdirs();
        this.udata.setUninstallerJarFilename(jar);
        this.udata.setUninstallerPath(dest);
        FileOutputStream out = new FileOutputStream(jar);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        this.idata.uninstallOutJar = outJar = new ZipOutputStream(bos);
        outJar.setLevel(9);
        this.udata.addFile(jar);
        HashSet<String> doubles = new HashSet<String>();
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            ZipInputStream inRes = new ZipInputStream(in[i]);
            ZipEntry zentry = inRes.getNextEntry();
            while (zentry != null) {
                if (!doubles.contains(zentry.getName())) {
                    doubles.add(zentry.getName());
                    outJar.putNextEntry(new ZipEntry(zentry.getName()));
                    int unc = inRes.read();
                    while (unc != -1) {
                        outJar.write(unc);
                        unc = inRes.read();
                    }
                    inRes.closeEntry();
                    outJar.closeEntry();
                }
                zentry = inRes.getNextEntry();
            }
            inRes.close();
        }
        InputStream in2 = MultiVolumeUnpacker.class.getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        outJar.putNextEntry(new ZipEntry("langpack.xml"));
        int read = in2.read();
        while (read != -1) {
            outJar.write(read);
            read = in2.read();
        }
        outJar.closeEntry();
    }

    private void informListeners(List[] customActions, int action, Object firstParam, Object secondParam, Object thirdParam) throws Exception {
        List listener = null;
        switch (action) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                listener = customActions[customActions.length - 1];
                break;
            }
            default: {
                listener = customActions[0];
            }
        }
        if (listener == null) {
            return;
        }
        Iterator iter = listener.iterator();
        while (iter.hasNext()) {
            if (this.shouldInterrupt()) {
                return;
            }
            InstallerListener il = (InstallerListener)iter.next();
            switch (action) {
                case 1: {
                    il.beforeFile((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 2: {
                    il.afterFile((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 3: {
                    il.beforeDir((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 4: {
                    il.afterDir((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 5: {
                    il.beforePack((Pack)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 6: {
                    il.afterPack((Pack)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 7: {
                    il.beforePacks((AutomatedInstallData)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 8: {
                    il.afterPacks((AutomatedInstallData)firstParam, (AbstractUIProgressHandler)secondParam);
                }
            }
        }
    }

    private List[] getCustomActions() {
        int i;
        String[] listenerNames = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] retval = new List[listenerNames.length + 1];
        for (i = 0; i < listenerNames.length; ++i) {
            retval[i] = (List)this.idata.customData.get(listenerNames[i]);
            if (retval[i] != null) continue;
            retval[i] = new ArrayList();
        }
        if (retval[0].size() > 0) {
            i = retval.length - 1;
            retval[i] = new ArrayList();
            Iterator iter = retval[0].iterator();
            while (iter.hasNext()) {
                InstallerListener li = (InstallerListener)iter.next();
                if (!li.isFileListener()) continue;
                retval[i].add(li);
            }
        }
        return retval;
    }

    private void handleAdditionalUninstallData(UninstallData udata, List[] customData) {
        udata.addAdditionalData("__uninstallLibs__", customData[2]);
        udata.addAdditionalData("uninstallerListeners", customData[1]);
        udata.addAdditionalData("uninstallerJars", customData[3]);
    }

    private boolean mkDirsWithEnhancement(File dest, PackFile pf, List[] customActions) throws Exception {
        String path = "unknown";
        if (dest != null) {
            path = dest.getAbsolutePath();
        }
        if (dest != null && !dest.exists() && dest.getParentFile() != null) {
            if (dest.getParentFile().exists()) {
                this.informListeners(customActions, 3, dest, pf, null);
            }
            if (!dest.mkdir()) {
                this.mkDirsWithEnhancement(dest.getParentFile(), pf, customActions);
                if (!dest.mkdir()) {
                    dest = null;
                }
            }
            this.informListeners(customActions, 4, dest, pf, null);
        }
        if (dest == null) {
            this.handler.emitError("Error creating directories", "Could not create directory\n" + path);
            this.handler.stopAction();
            return false;
        }
        return true;
    }

    public static synchronized boolean isDiscardInterrupt() {
        return discardInterrupt;
    }

    public static synchronized void setDiscardInterrupt(boolean di) {
        discardInterrupt = di;
        MultiVolumeUnpacker.setInterruptDesired(false);
    }

    public static boolean isInterruptDesired() {
        return interruptDesired;
    }

    private static void setInterruptDesired(boolean interruptDesired) {
        MultiVolumeUnpacker.interruptDesired = interruptDesired;
    }
}

