/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     January 2002
 *
 */

#include  <stdio.h>
#include  <string.h>
#include  <gtk/gtk.h>


GtkWidget  *searchlabel, *searchword;
GtkWidget  *text, *textblock, *scrollblock;
GtkWidget  *summary;
GtkTextBuffer  *textpad;
GtkTextIter  iter;

char  holder[200], temp[200], report[30], seek[100];
char  type[20], tag[30], title[100];

void  word(GtkWidget *widget)
{
  GtkTooltips  *tooltips;
  GtkWidget  *window, *panel, *description, *selector, *controls;
  GtkWidget  *key0, *key1, *key3;

  extern  void  close_window(GtkWidget *);    /* defined in file cleanup.c */
  void  put_text_inplace();

  tooltips = gtk_tooltips_new();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile inspect");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_window_set_default_size(GTK_WINDOW(window), 500, 510);
  panel = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), panel);
  description = gtk_label_new("References found in the database containing search word");
  gtk_box_pack_start(GTK_BOX(panel), description, FALSE, TRUE, 10);
  selector = gtk_hbox_new(FALSE, 0);
  searchlabel = gtk_label_new("Word to find:");
  gtk_box_pack_start(GTK_BOX(selector), searchlabel, FALSE, TRUE, 10);
  searchword = gtk_entry_new_with_max_length(100);
  gtk_box_pack_start(GTK_BOX(selector), searchword, FALSE, TRUE, 10);
  g_signal_connect(GTK_OBJECT(searchword), "activate",
                   G_CALLBACK(put_text_inplace), NULL);
  key3 = gtk_button_new_with_label("Execute");
  gtk_widget_set_usize(GTK_WIDGET(key3), 90, -1);
  g_signal_connect(GTK_OBJECT(key3), "clicked",
                   G_CALLBACK(put_text_inplace), NULL);
  gtk_tooltips_set_tip(tooltips, key3,
                       "Execute search with this new word", NULL);
  gtk_box_pack_end(GTK_BOX(selector), key3, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(panel), selector, FALSE, TRUE, 10);

                          /* create the text display part of the window */
  textblock = gtk_scrolled_window_new(NULL, NULL);
  textpad = gtk_text_buffer_new(NULL);
  text = gtk_text_view_new_with_buffer(textpad);
  gtk_container_add(GTK_CONTAINER(textblock), text);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(textblock),
                                 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start_defaults(GTK_BOX(panel), textblock); 

                           /* put the window control buttons in place */
  controls = gtk_hbox_new(FALSE, 0);
  key0 = gtk_button_new_with_label("CANCEL");
  gtk_widget_set_usize(GTK_WIDGET(key0), 90, -1);
  g_signal_connect(GTK_OBJECT(key0), "clicked",
                   G_CALLBACK(close_window), NULL);
  gtk_tooltips_set_tip(tooltips, key0,
                       "Finish this reference probe", NULL);
  gtk_box_pack_end(GTK_BOX(controls), key0, FALSE, FALSE, 10);
                           /* and put the summary line in place */
  summary = gtk_entry_new();
  gtk_editable_set_editable(GTK_EDITABLE(summary), FALSE);
  gtk_widget_set_usize(GTK_WIDGET(summary), 150, 20);
  gtk_box_pack_start(GTK_BOX(controls), summary, FALSE, FALSE, 10);
  gtk_box_pack_end(GTK_BOX(panel), controls, FALSE, TRUE, 10);

                          /* now put the 'style' for the text output */
  gtk_text_buffer_create_tag(textpad, "blackface",
                             "foreground", "black", NULL);
  gtk_text_buffer_create_tag(textpad, "emphasis",
                             "foreground", "red", NULL);
  gtk_text_buffer_create_tag(textpad, "target",
                             "foreground", "green", NULL);
  gtk_text_buffer_create_tag(textpad, "point",
                             "size", 11 * PANGO_SCALE, NULL);
  gtk_text_buffer_create_tag(textpad, "font",
                             "style", PANGO_STYLE_NORMAL, NULL);

                          /* put the composite window on the screen */
  gtk_widget_show_all(window);
}



/* This procedure performs the searching of the BibTeX database and returns
 * its results to the text window created in the procedure  word()  above
 */

void  put_text_inplace(GtkWidget *widget)
{
  int  i, count, start_flag, print_flag, length;
  char  *start, *end;

  extern  void  error();                      /* defined in file error.c */
  extern  FILE  *refFile;                     /* defined in xbibfile.c */

  strcpy(seek, gtk_entry_get_text(GTK_ENTRY(searchword)));

  i = 0;
  count = 0;
  rewind(refFile);
  gtk_text_buffer_get_iter_at_offset(textpad, &iter, 0);
  while ( ( holder[i] = getc(refFile) ) != EOF )  {
    if ( holder[i] == '\n' )  {
      holder[i+1] = '\0';
      i = 0;
      if ( holder[0] == '@' )  {
        start_flag = 0;
	print_flag = 0;
        if ( strstr( holder, "ARTICLE") ) 
	  strcpy(temp, "Article   ");
        if ( strstr( holder, "BOOK") ) 
	  strcpy(temp, "Book   ");
        if ( strstr( holder, "BOOKLET") ) 
	  strcpy(temp, "Booklet   ");
        if ( strstr( holder, "CONFERENCE") ) 
	  strcpy(temp, "Conference  ");
        if ( strstr( holder, "INBOOK") ) 
	  strcpy(temp, "inBook   ");
        if ( strstr( holder, "INCOLLECTION") ) 
	  strcpy(temp, "Incollection   ");
        if ( strstr( holder, "INPROCEEDINGS") ) 
	  strcpy(temp, "inProceedings   ");
        if ( strstr( holder, "MANUAL") ) 
	  strcpy(temp, "Manual   ");
        if ( strstr( holder, "MASTERSTHESIS") ) 
	  strcpy(temp, "Masters   ");
        if ( strstr( holder, "MISC") ) 
	  strcpy(temp, "Misc   ");
        if ( strstr( holder, "PHDTHESIS") ) 
	  strcpy(temp, "PhD Thesis   ");
        if ( strstr( holder, "PROCEEDINGS") ) 
	  strcpy(temp, "Proceedings   ");
        if ( strstr( holder, "TECHREPORT") ) 
	  strcpy(temp, "Tech Rerort   ");
        if ( strstr( holder, "UNPUBLISHED") ) 
	  strcpy(temp, "Unpublished   ");
	strcpy(type, temp);
	if ( start = strstr( holder, "{" ) ) 
	  if ( end = strstr( holder, "," ) )  {
	    *end = ' ';
	    end++;
	    *end = ' ';
	    end++;
	    *end = '\0';
  	    strcpy(tag, start+1);
	  }
	  else {
	    error(widget, GINT_TO_POINTER(9));
	    g_print("Format error in this BibTeX file - no ending ,");
	  }
	else  {
	  error(widget, GINT_TO_POINTER(9));
	  g_print("Format error in this BibTeX file - no {");
	}
      }
                           /* if the line starts with 'title = {' */
      if ( start = strstr( holder, "  title = {" ) )
        if ( end = strstr( holder, "}," )  ) {
	  if ( (end - start) > 60 )
	    end = start + 60;
	  *end = '\n';
	  end++;
	  *end = '\0';
	  start += 11;
	  strcpy(title, start);
	}
	else  {
	  error(widget, GINT_TO_POINTER(9));
	  g_print("Format error in this BibTeX file - no ending ,}");
	}
	                   /* if the line starts with 'annote = {' */
      strcpy(temp, holder);
      if ( start = strstr(temp, "  annote = {") )  {
        start_flag = 1;
	strcpy(temp, start+12);
      }
	                   /* if the line contains the terminator '} }' */
      if ( start_flag )  {
        if ( start = strstr(temp, seek) )  {
	  if ( !print_flag )  {
	    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                type, -1,
			"blackface", "point", "font", NULL);
	    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                tag, -1,
			"emphasis", "point", "font", NULL);
	    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                title, -1,
			"blackface", "point", "font", NULL);
	    print_flag = 1;
	    count++;
	  }
	  *start = '\0';
	  gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                "   ", -1,
			"blackface", "point", "font", NULL);
	  gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                temp, -1,
			"blackface", "point", "font", NULL);
	  gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                seek, -1,
			"target", "point", "font", NULL);
	  length = strlen(seek);
	  start += length;
	  if (  end = strstr(start, "} }") )  {
	    *end = '\0';
	    end++;
	    *end = '\n';
	    start_flag = 0;
	  }
	  gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                start, -1,
			"blackface", "point", "font", NULL);
	}
      }
    }
    else
      i++;
  }
  sprintf(report, "%d references displayed", count);
  gtk_entry_set_text(GTK_ENTRY(summary), report);
}
