%(encoding:utf-8)
\DeclareLanguage{french}

\SetLanguageScript{La}

\AddLanguageProcess{input}{inputtex}
\AddLanguageProcess{text}{fratext}

\DeclareLanguageCommand\LeftPointingDoubleAngleQuotationMark
  {processes}{\fr@lguillemets}
\DeclareLanguageCommand\RightPointingDoubleAngleQuotationMark
  {processes}{\fr@rguillemets}
% \DeclareLanguageCommand{\mem@uppercase}
%   {processes}[1]{{\SetMemProcess{case}{\fr@uc}\SelectProcesses#1}}

\DeclareLanguageProperty{uppercase = unaccented}
    {\DeclareLanguageProcess{uppercase}{ucnoacc}}
\DeclareLanguageProperty{uppercase = accented}
    {\DeclareLanguageProcess{uppercase}{uppercase}}

\newcounter{niveauguillemets}[paragraph]

% When fr@guillemets is expanded, the current internal
% mem representation is already Unicode.

\DeclareLanguageProperty{guillemets = line}
  {\def\fr@lguillemets{%
    ^^^^00ab\kern.1667em%
    \ifthenelse{\value{niveauguillemets} = 1}%
      {\everypar={}\localleftbox{^^^^00ab\kern.1667em}}%
      {\everypar={{\popocplist^^^^00ab}\kern.1667em}%
       \setcounter{niveauguillemets}{1}}}%
   \def\fr@rguillemets{%
     \unskip\kern.1667em%
     ^^^^00bb%
     \everypar={}\localleftbox{}%
     \ifthenelse{\value{niveauguillemets} = 1}
        {\everypar={{\popocplist^^^^00ab}\kern.1667em}%
         \setcounter{niveauguillemets}{0}}{}}}

\DeclareLanguageProperty{guillemets = paragraph}
  {\def\fr@lguillemets{%
      ^^^^00ab\kern.1667em
      \everypar={^^^^00ab \kern.1667em}}%
   \def\fr@rguillemets{%
      \unskip\kern.1667em^^^^00bb%
       \everypar={}}}

\DeclareLanguageProperty{guillemets = normal}
  {\def\fr@lguillemets{^^^^00ab\kern.1667em}%
   \def\fr@rguillemets{\unskip\kern.1667em^^^^00bb}}
\def\fr@lguillemets{^^^^00ab\kern.1667em}
\def\fr@rguillemets{\unskip\kern.1667em^^^^00bb}

\DeclareLanguageCommand\LeftDoubleQuotationMark
  {processes}{^^^^201c}
\DeclareLanguageCommand\RightDoubleQuotationMark
  {processes}{^^^^201d}
\DeclareLanguageCommand\QuestionMark
  {processes}{\unskip\kern.1667em?}
\DeclareLanguageCommand\ExclamationMark
  {processes}{\unskip\kern.1667em!}
\DeclareLanguageCommand\Semicolon
  {processes}{\unskip\kern.1667em;}
\DeclareLanguageCommand\Colon
  {processes}{\unskip~:}

\DeclareLanguageCommand*\refname
  {names}{Références}%
\DeclareLanguageCommand*\abstractname
  {names}{Résumé}%
\DeclareLanguageCommand*\bibname
  {names}{Bibliographie}%
\DeclareLanguageCommand*\prefacename
  {names}{Préface}%
\DeclareLanguageCommand*\chaptername
  {names}{Chapitre}%
\DeclareLanguageCommand*\appendixname
  {names}{Annexe}%
\DeclareLanguageCommand*\contentsname
  {names}{Table des matières}%
\DeclareLanguageCommand*\listfigurename
  {names}{Table des figures}%
\DeclareLanguageCommand*\listtablename
  {names}{Liste des tableaux}%
\DeclareLanguageCommand*\indexname
  {names}{Index}%
\DeclareLanguageCommand*\figurename
  {names}{{\scshape Fig.}}%
\DeclareLanguageCommand*\tablename
  {names}{{\scshape Tab.}}%
\DeclareLanguageCommand*\partname
  {names}{\protect\@Fpt partie}%
\def\@Fpt{{\ifcase\value{part}\or Première\or Deuxième\or
   Troisième\or Quatrième\or Cinquième\or Sixième\or
   Septième\or Huitième\or Neuvième\or Dixième\or Onzième\or
   Douzième\or Treizième\or Quatorzième\or Quinzième\or
   Seizième\or Dix-septième\or Dix-huitième\or Dix-neuvième\or
   Vingtième\fi}\space\def\thepart{}}%
\DeclareLanguageCommand*\pagename
  {names}{page}%
\DeclareLanguageCommand*\seename
  {names}{{\emph{voir}}}%
\DeclareLanguageCommand*\alsoname
  {names}{{\emph{voir aussi}}}%
\DeclareLanguageCommand*\enclname
  {names}{P.~J. }%
\DeclareLanguageCommand*\ccname
  {names}{Copie à }%
\DeclareLanguageCommand*\headtoname
  {names}{}%
\DeclareLanguageCommand*\proofname
  {names}{Démonstration}% for AMS-\LaTeX

\DeclareDateFunction{wwww}{%
  \ifcase\weekday\or dimanche\or lundi\or mardi\or
  mercredi\or jeudi\or vendredi\or samedi\fi}

\DeclareDateFunction{mmmm}{%
  \ifcase\month\or janvier\or février\or mars\or avril\or
  mai\or juin\or juillet\or ao\^ut\or septembre\or octobre\or
  novembre\or décembre\fi}

\DeclareDateFunction{ddd}{%
  \the\day\ifnum\day=\@ne\ier\fi}

\DeclareDateCommand{\today}{<ddd> <mmmm> <yyyy>}

\endinput
