/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.lang;

import korlibs.io.lang.Charset;
import korlibs.memory.BitsKt;
import korlibs.memory.ByteArrayBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J,\u0010\t\u001a\u00020\u00062\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lkorlibs/io/lang/UTC8CharsetBase;", "Lkorlibs/io/lang/Charset;", "name", "", "(Ljava/lang/String;)V", "createByte", "", "codePoint", "shift", "decode", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "src", "", "start", "end", "encode", "", "Lkorlibs/memory/ByteArrayBuilder;", "", "estimateNumberOfBytesForCharacters", "nchars", "estimateNumberOfCharactersForBytes", "nbytes", "korio"})
@SourceDebugExtension(value={"SMAP\nCharset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Charset.kt\nkorlibs/io/lang/UTC8CharsetBase\n+ 2 Charset.kt\nkorlibs/io/lang/Charset$Companion\n+ 3 ByteArrayBuilder.kt\nkorlibs/memory/ByteArrayBuilder\n*L\n1#1,291:1\n94#2,18:292\n113#2:326\n59#3,2:310\n59#3,2:312\n59#3,2:314\n59#3,2:316\n59#3,2:318\n59#3,2:320\n59#3,2:322\n59#3,2:324\n*S KotlinDebug\n*F\n+ 1 Charset.kt\nkorlibs/io/lang/UTC8CharsetBase\n*L\n124#1:292,18\n124#1:326\n126#1:310,2\n130#1:312,2\n132#1:314,2\n133#1:316,2\n136#1:318,2\n137#1:320,2\n138#1:322,2\n141#1:324,2\n*E\n"})
public class UTC8CharsetBase
extends Charset {
    public UTC8CharsetBase(@NotNull String name) {
        super(name);
    }

    @Override
    public int estimateNumberOfCharactersForBytes(int nbytes) {
        return nbytes * 2;
    }

    @Override
    public int estimateNumberOfBytesForCharacters(int nchars) {
        return nchars * 2;
    }

    private final int createByte(int codePoint, int shift) {
        return codePoint >> shift & 0x3F | 0x80;
    }

    @Override
    public void encode(@NotNull ByteArrayBuilder out, @NotNull CharSequence src, int start, int end2) {
        Charset.Companion this_$iv = Charset.Companion;
        boolean $i$f$decodeCodePoints = false;
        int highSurrogate$iv = 0;
        block4: for (int n$iv = start; n$iv < end2; ++n$iv) {
            ByteArrayBuilder this_$iv2;
            boolean $i$f$append;
            byte v$iv;
            int codePoint$iv;
            int n;
            block12: {
                int char$iv;
                block11: {
                    char$iv = src.charAt(n$iv);
                    boolean bl = 55296 <= char$iv ? char$iv < 57344 : false;
                    if (!bl) break block11;
                    switch (BitsKt.extract(char$iv, 10, 6)) {
                        case 54: {
                            highSurrogate$iv = char$iv & 0x3FF;
                            continue block4;
                        }
                        case 55: {
                            n = 65536 + (highSurrogate$iv << 10 | char$iv & 0x3FF);
                            break block12;
                        }
                        default: {
                            throw new IllegalStateException(("Unknown " + char$iv).toString());
                        }
                    }
                }
                n = char$iv;
            }
            int codePoint = codePoint$iv = n;
            boolean bl = false;
            if ((codePoint & 0xFFFFFF80) == 0) {
                ByteArrayBuilder byteArrayBuilder = out;
                v$iv = (byte)codePoint;
                $i$f$append = false;
                this_$iv2.appendFast(v$iv);
                continue;
            }
            if ((codePoint & 0xFFFFF800) == 0) {
                this_$iv2 = out;
                v$iv = (byte)(codePoint >> 6 & 0x1F | 0xC0);
                $i$f$append = false;
                this_$iv2.appendFast(v$iv);
            } else if ((codePoint & 0xFFFF0000) == 0) {
                this_$iv2 = out;
                v$iv = (byte)(codePoint >> 12 & 0xF | 0xE0);
                $i$f$append = false;
                this_$iv2.appendFast(v$iv);
                this_$iv2 = out;
                v$iv = (byte)this.createByte(codePoint, 6);
                $i$f$append = false;
                this_$iv2.appendFast(v$iv);
            } else if ((codePoint & 0xFFE00000) == 0) {
                this_$iv2 = out;
                v$iv = (byte)(codePoint >> 18 & 7 | 0xF0);
                $i$f$append = false;
                this_$iv2.appendFast(v$iv);
                this_$iv2 = out;
                v$iv = (byte)this.createByte(codePoint, 12);
                $i$f$append = false;
                this_$iv2.appendFast(v$iv);
                this_$iv2 = out;
                v$iv = (byte)this.createByte(codePoint, 6);
                $i$f$append = false;
                this_$iv2.appendFast(v$iv);
            }
            this_$iv2 = out;
            v$iv = (byte)(codePoint & 0x3F | 0x80);
            $i$f$append = false;
            this_$iv2.appendFast(v$iv);
        }
    }

    @Override
    public int decode(@NotNull StringBuilder out, @NotNull byte[] src, int start, int end2) {
        if (start < 0 || start > src.length || end2 < 0 || end2 > src.length) {
            throw new IllegalStateException("Out of bounds".toString());
        }
        int i = start;
        while (i < end2) {
            int c = src[i] & 0xFF;
            int n = c >> 4;
            boolean bl = 0 <= n ? n < 8 : false;
            if (bl) {
                Charset.Companion.appendCodePointV(out, c);
                ++i;
                continue;
            }
            boolean bl2 = 12 <= n ? n < 14 : false;
            if (bl2) {
                if (i + 1 >= end2) break;
                Charset.Companion.appendCodePointV(out, (c & 0x1F) << 6 | src[i + 1] & 0x3F);
                i += 2;
                continue;
            }
            if (n == 14) {
                if (i + 2 >= end2) break;
                Charset.Companion.appendCodePointV(out, (c & 0xF) << 12 | (src[i + 1] & 0x3F) << 6 | src[i + 2] & 0x3F);
                i += 3;
                continue;
            }
            if (n == 15) {
                if (i + 3 >= end2) break;
                Charset.Companion.appendCodePointV(out, BitsKt.insert(BitsKt.insert(BitsKt.insert(BitsKt.insert(0, BitsKt.extract(src[i + 0], 0, 3), 18, 3), BitsKt.extract(src[i + 1], 0, 6), 12, 6), BitsKt.extract(src[i + 2], 0, 6), 6, 6), BitsKt.extract(src[i + 3], 0, 6), 0, 6));
                i += 4;
                continue;
            }
            out.append('\ufffd');
            ++i;
        }
        return i - start;
    }
}

