%-*-Latex-*- 



([ebeg] 
(ealias "\\elder" "ELDER")
(setq *elder-trace* t)
 (setq *formal-version* nil)
	(estyle "article") 

""
[eend])

\begin{document}

\title{Userguide to autoview.el}
\author{Deepak Goel\footnote{deego@glue.umd.edu}}
\maketitle

\section{Intro}

Autoview and associated files are available from ([ebf]html
http://www.glue.umd.edu/\symbol{126}deego/emacspub/autoview[eef]). This
userguide is available from ([ebf]html
http://www.glue.umd.edu/\symbol{126}deego/emacspub/autoview/usrguide/usrguide.html[eef]).

While you are editing your file.tex, autoview will (run in a separate
emacs and) continually, intelligently, and automatically keep
processing your latex file, generate a .ps file and gv (view) the file
for you.. You can modify it to suit your needs..

\section{Customizing it}
Edit autoview and (setq) the *directory* and *file* to whatever file
you are editing nowadays. NOTE: *file* is the *file* without the
extension.  If you like, {\bf setq} the view-command and shell-command
to what you want. Else they will be {\bf {\it bind}}-ed to their
default values based on the *file* and *directory* you provide.

IF you have any problems, please feel free to contact the author. 


Autoview processes the file only if it finds that the file has been
updated (saved!) since it was last processed. It checks for the file
every *repeattime* seconds. Other minor options are not worth going
into.


I would appreciate feedback. If you find at any place that a
particular choice should have been made available to the user,
please let me know... Your contributions are most welcome.

\section{Running it}
Please either:
\begin{itemize}

\item{download runauto.r from the autoview homepage, and add this to
your .aliases: 
\begin{verbatim}
alias elatstart 'source ~/runauto.r'
\end{verbatim}
}
\item{
or add this to your .aliases or .login (assumes tcsh)

\begin{verbatim}
alias elatstart ' /usr/local/bin/emacs20 -i -q  \\
-l ~/emacs/emacspub/autoview.el -title ELAT -fn 6x13 -geometry \\
90x35+1400+1000 -bg LightGreen -f elatstart &'
\end{verbatim}
Then, typing elatstart will run autoview for you.

Please don't forget to change the names of the directories to the ones
on your local system.

{\bf {\large PLEASE edit autoview.el and find where I load *my* profile. You probably
 don't want that. Change that to (load "generalprofile.el"). And don't
 forget to download this generalprofile.el as well. }}

 }
\end{itemize}

\section{Other features}
Oh, did I mention that the processing is a bit smart in another
way. If an error occurs, it stops execution there, and tries to take
you to where the error occurred. Latex does not output any unique
error-string, so it tries to detect several strings: ``Undefined
symbol'', ``Error'' etc.  



\end{document}