program DDETest;

uses Strings, WinTypes, WinProcs, WObjects, Win31, DDEML, ctl3dv2,
     rc_dde, WinDos;

{$R DDETEST}

Const
  BufSize=32*1024-16;
  lbrace =#123; rbrace = #125; { Can't write these explicitly in the code! }

type

  PDDEClientWindow = ^TDDEClientWindow;
  TDDEClientWindow = object(TDlgWindow)
    Inst: Longint;
    CallBackPtr: ^TCallback;

    constructor Init(AParent: PWindowsObject; AName: PChar);
    destructor  Done; virtual;
    procedure   HelpContents(var Msg: TMessage); virtual cm_First+Acc_Help;
    procedure   SetupWindow; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var Class: TWndClass); virtual;
    procedure   WMSysColorChange(var Msg : TMessage);
                 virtual wm_first + wm_SysColorChange;       { for 3-D controls }

    procedure   UpdateCBox(id: integer; AppName: PChar);
    procedure   UpdateService(Service: PChar);
    procedure   SelectService(var Msg: TMessage);
                              virtual id_first+dl_ServiceEBox;
    procedure   UpdateTopic(Topic: PChar);
    procedure   SelectTopic(var Msg: TMessage);
                              virtual id_first+dl_TopicEBox;    

    function    Connect(Service,Topic: PChar;
                    var ServiceHsz, TopicHsz: Hsz; var ConvHdl: HConv): boolean;
    procedure   DisConnect(var ServiceHsz, TopicHsz: Hsz; var ConvHdl: HConv);
    procedure   RequestBtn(var Msg: TMessage); virtual id_first+dl_RequestBtn;
    procedure   ExecuteBtn(var Msg: TMessage); virtual id_first+dl_ExecuteBtn;
    procedure   PokeBtn(var Msg: TMessage);    virtual id_First+dl_PokeBtn;
    procedure   EnableHex;
    procedure   StrSelect(var Msg: TMessage);  virtual id_first+dl_StringRBox;
    procedure   ByteSelect(var Msg: TMessage); virtual id_first+dl_ByteRBox;
    procedure   IntegerSelect(var Msg: TMessage); virtual id_first+dl_IntegerRBox;
    procedure   WordSelect(var Msg: TMessage); virtual id_first+dl_WordRBox;
    procedure   LongSelect(var Msg: TMessage); virtual id_first+dl_LongRBox;

    procedure   ok(var Msg: TMessage);         virtual id_first+id_ok;
    procedure   wmDestroy(var Msg: TMessage);  virtual wm_First+wm_Destroy;
  end;


{ Application object }

  TDDEClientApp = object(TApplication)
    procedure InitInstance;   virtual;
    procedure InitMainWindow; virtual;
    function  ProcessAppMsg(var Message: TMsg) : Boolean; virtual;
  end;

{ Global variables }

var
  App: TDDEClientApp;
  MainIcon: HIcon;
  IniFile,HelpFile: array[0..fsPathName] of char;
  DdeTimeout: longint;
  Buf0: PChar;
  LastText: string;

function Num2Str(i: LongInt): String;
var
  tmp: String;
begin
  tmp:='';
  Str(i,tmp);
  Num2Str:=tmp;
end;

function DdeError(Inst: longint): string;
var
  S: string;
  l: word;
begin
  S:='<unknown>';
  l:=DdeGetLastError(Inst);
  case l of
    DMLERR_ADVACKTIMEOUT       : s:='DMLERR_ADVACKTIMEOUT';
    DMLERR_BUSY                : s:='DMLERR_BUSY';
    DMLERR_DATAACKTIMEOUT      : s:='DMLERR_DATAACKTIMEOUT';
    DMLERR_DLL_NOT_INITIALIZED : s:='DMLERR_DLL_NOT_INITIALIZED';
    DMLERR_EXECACKTIMEOUT      : s:='DMLERR_EXECACKTIMEOUT';
    DMLERR_INVALIDPARAMETER    : s:='DMLERR_INVALIDPARAMETER';
    DMLERR_MEMORY_ERROR        : s:='DMLERR_MEMORY_ERROR';
    DMLERR_NO_CONV_ESTABLISHED : s:='DMLERR_NO_CONV_ESTABLISHED';
    DMLERR_NO_ERROR            : s:='DMLERR_NO_ERROR';
    DMLERR_NOTPROCESSED        : s:='DMLERR_NOTPROCESSED';
    DMLERR_POKEACKTIMEOUT      : s:='DMLERR_POKEACKTIMEOUT';
    DMLERR_POSTMSG_FAILED      : s:='DMLERR_POSTMSG_FAILED';
    DMLERR_REENTRANCY          : s:='DMLERR_REENTRANCY';
    DMLERR_SERVER_DIED         : s:='DMLERR_SERVER_DIED';
    DMLERR_UNADVACKTIMEOUT     : s:='DMLERR_UNADVACKTIMEOUT';
  end;
  DdeError:=S;
end;

{ Local Function: CallBack Procedure for DDEML }

function CallbackProc(CallType, Fmt: Word; Conv: HConv; hsz1, hsz2: HSZ;
  Data: HDDEData; Data1, Data2: Longint): HDDEData; export;
var
  ThisWindow: PDDEClientWindow;
begin
  CallbackProc := 0;    { See if proved otherwise }

  ThisWindow := PDDEClientWindow(App.MainWindow);

  case CallType of
    xtyp_Register:
      begin
        { Nothing ... Just return 0 }
      end;
    xtyp_Unregister:
      begin
        { Nothing ... Just return 0 }
      end;
    xtyp_xAct_Complete:
      begin
        { Nothing ... Just return 0 }
      end;
    xtyp_Request, Xtyp_AdvData:
      begin
        CallbackProc := dde_FAck;
      end;
  end;
end;


{ TDDEClientWindow Methods }

{ Constructs an instance of the DDE Client Window.  Constructs the 
  window using the inherited constructor, then initializes the instance
  data.
}
constructor TDDEClientWindow.Init(AParent: PWindowsObject; AName: PChar);
var
  I : Integer;
  F: array[0..255] of char;
begin
  TDlgWindow.Init(AParent, AName);

  Inst       := 0;      { Must be zero for first call to DdeInitialize } 
  CallBackPtr:= nil;    { MakeProcInstance is called in SetupWindow    }

  GetPrivateProfileString('General','Timeout','10000',F,255,IniFile);
  DdeTimeout:=0;
  for i:=StrLen(F)-1 downto 0 do
    DdeTimeout:=10*DdeTimeout+Ord(F[i])-Ord('0');
  LastText:='';
end;

{ Destroys an instance of the Client window.  Frees the DDE string
  handles, and frees the callback proc instance if they exist.  Also 
  calls DdeUninitialize to terminate the conversation.  Then calls on
  the ancestral destructor to finish the job.
}
destructor TDDEClientWindow.Done;
begin
  if Inst <> 0 then
    DdeUninitialize(Inst);   { Ignore the return value }

  if CallBackPtr <> nil then
    FreeProcInstance(CallBackPtr);

  TDlgWindow.Done;
end;

procedure TDDEClientWindow.HelpContents(var Msg: TMessage);
begin
  WinHelp(HWindow,HelpFile,Help_Contents,0);
end;

procedure TDDEClientWindow.UpdateCBox(id: integer; AppName: PChar);
var
  i,Slen: integer;
  buf: PChar;
  tmp: string;
  F: array[0..255] of char;
begin
  Buf:=Buf0;
  GetPrivateProfileString(Appname,Nil,'<none>',Buf,BufSize,IniFile);
  slen:=StrLen(Buf); i:=0;
  GetDlgItemText(HWindow,id,F,255);
  SendDlgItemMsg(id,cb_ResetContent,0,0);
  SetDlgItemText(HWindow,id,'');
  if StrPas(Buf)<>'<none>' then
  while Slen>0 do
  begin
    inc(i);
    tmp:=StrPas(Buf);
    i:=Pos('\'+lbrace,tmp);
    while i>0 do
    begin
      Delete(tmp,i,1); tmp[i]:='[';
      i:=Pos('\'+lbrace,tmp);
    end;
    i:=Pos('\'+rbrace,tmp);
    while i>0 do
    begin
      Delete(tmp,i,1); tmp[i]:=']';
      i:=Pos('\'+rbrace,tmp);
    end;
    StrPCopy(F,tmp);
    SendDlgItemMsg(id,cb_AddString,0,Longint(@F));
    Buf:=Buf+Slen+1;
    Slen:=StrLen(Buf);
    SendDlgItemMsg(id,cb_SetCurSel,0,0);
  end else SetDlgItemText(HWindow,id,F);
end;

{ Completes the initialization of the DDE Server Window.  Performs those 
  actions which require a valid window.  Initializes the use of the DDEML.
}
procedure TDDEClientWindow.SetupWindow;
var
  Sysmenu: HMenu;
  F,F1: array[0..255] of char;
begin
  TDlgWindow.SetupWindow;
  Ctl3DSubclassDlgEx(HWindow,Ctl3d_All);
  SysMenu:=GetSystemMenu(HWindow,false);
  RemoveMenu(Sysmenu,sc_Size,mf_ByCommand);
  RemoveMenu(Sysmenu,sc_Maximize,mf_ByCommand);

  SendDlgItemMsg(dl_StringRBox,bm_SetCheck,bf_Checked,0);
  SendDlgItemMsg(dl_DecimalRBox,bm_SetCheck,bf_Checked,0);

  EnableHex;

  CallBackPtr := MakeProcInstance(@CallBackProc, HInstance);

{ Initialize the DDE and setup the callback function. }
  if CallBackPtr <> nil then
  begin
    if DdeInitialize(Inst, TCallback(CallBackPtr), AppCmd_ClientOnly,
      0) <> dmlErr_No_Error then
    begin
      MessageBox(HWindow, 'Can''t initialize!', Application^.Name,
        mb_IconStop);
      PostQuitMessage(0);
    end;
  end;
  UpdateCBox(dl_ServiceEBox,'Services');

  GetPrivateProfileString('Startup','Service','<first>',F,255,IniFile);
  if StrPas(F)='<first>' then
    SendDlgItemMsg(dl_ServiceEbox,cb_GetLbtext,0,Longint(@F))
  else SetDlgItemText(HWindow,dl_ServiceEBox,F);
  UpdateService(F);

  GetPrivateProfileString('Startup','Topic','<first>',F,255,IniFile);
  if StrPas(F)<>'<first>' then
  begin
    SetDlgItemText(HWindow,dl_TopicEBox,F);
    UpdateTopic(F);
  end;

  GetPrivateProfileString('Startup','Macro','<first>',F,255,IniFile);
  if StrPas(F)<>'<first>' then SetDlgItemText(HWindow,dl_MacroEBox,F);

  GetPrivateProfileString('Startup','PokeItem','<first>',F,255,IniFile);
  if StrPas(F)<>'<first>' then SetDlgItemText(HWindow,dl_PokeItemEBox,F);

  GetPrivateProfileString('Startup','RequestItem','<first>',F,255,IniFile);
  if StrPas(F)<>'<first>' then SetDlgItemText(HWindow,dl_ReqItemEBox,F);

  GetPrivateProfileString('Startup','Data','<first>',F,255,IniFile);
  if StrPas(F)<>'<first>' then SetDlgItemText(HWindow,dl_DataEBox,F);
end;

procedure TDDEClientWindow.UpdateService(Service: PChar);
var
  tmp: string;
  F: array[0..255] of char;
  i: integer;
begin
  tmp:=StrPas(Service)+':Topics'; StrPCopy(F,tmp);
  UpdateCBox(dl_TopicEBox,F);
  SendDlgItemMsg(dl_TopicEbox,cb_GetLbtext,0,Longint(@F));
  UpdateTopic(F);
end;

procedure TDDEClientWindow.SelectService(var Msg: TMessage);
var
  Service: array[0..255] of char;
  i: integer;
  tmp: string;
begin
  if (Msg.LParamHi=cbn_KillFocus) or (Msg.LParamHi=cbn_SelChange) then
  begin
    if Msg.lParamHi=cbn_SelChange then
    begin
      i:=SendDlgItemMsg(dl_ServiceEBox,cb_GetCurSel,0,0);
      SendDlgItemMsg(dl_ServiceEBox,cb_GetLbText,i,Longint(@Service));
    end else GetDlgItemText(HWindow,dl_ServiceEBox,Service,255);
    if StrPas(Service)<>LastText then
      UpdateService(Service);
    LastText:=StrPas(Service);
  end else if Msg.LParamHi=cbn_SetFocus then
  begin
    GetDlgItemText(HWindow,dl_ServiceEBox,Service,255);
    LastText:=StrPas(Service);
  end;
  DefWndProc(Msg);
end;

procedure TDDEClientWindow.UpdateTopic(Topic: PChar);
var
  tmp: string;
  Service,F: array[0..255] of char;
  i: integer;
begin
  i:=SendDlgItemMsg(dl_ServiceEBox,cb_GetCurSel,0,0);
  if i=cb_Err then
    GetDlgItemText(HWindow,dl_TopicEBox,Service,255)
  else
    SendDlgItemMsg(dl_ServiceEBox,cb_GetLbText,i,longint(@Service));

  tmp:=StrPas(Service)+'.'+StrPas(Topic)+':RequestItems'; StrPCopy(F,tmp);
  UpdateCBox(dl_ReqItemEBox,F);
  tmp:=StrPas(Service)+'.'+StrPas(Topic)+':PokeItems'; StrPCopy(F,tmp);
  UpdateCBox(dl_PokeItemEBox,F);
  tmp:=StrPas(Service)+'.'+StrPas(Topic)+':Macros'; StrPCopy(F,tmp);

  UpdateCBox(dl_MacroEBox,F);
end;

procedure TDDEClientWindow.SelectTopic(var Msg: TMessage);
var
  Topic: array[0..255] of char;
  i: integer;
begin
  if (Msg.LParamHi=cbn_KillFocus) or (Msg.LParamHi=cbn_SelChange) then
  begin
    if Msg.lParamHi=cbn_SelChange then
    begin
      i:=SendDlgItemMsg(dl_TopicEBox,cb_GetCurSel,0,0);
      SendDlgItemMsg(dl_TopicEBox,cb_GetLbText,i,Longint(@Topic));
    end else GetDlgItemText(HWindow,dl_TopicEBox,Topic,255);
    if StrPas(Topic)<>LastText then
      UpdateTopic(Topic);
    LastText:=StrPas(Topic);
  end else if Msg.LParamHi=cbn_SetFocus then
  begin
    GetDlgItemText(HWindow,dl_TopicEBox,Topic,255);
    LastText:=StrPas(Topic);
  end;
  DefWndProc(Msg);
end;

procedure TDDEClientWindow.WMSysColorChange;
begin
  Ctl3dColorChange;
end;

function TDDEClientWindow.GetClassName: PChar;
begin
  GetClassName:='DDETest';
end;

procedure TDDEClientWindow.GetWindowClass(var Class: TWndClass);
begin
  TDlgWindow.GetWindowClass(Class);
  Class.hicon:=MainIcon;
end;

function TDDEClientWindow.Connect(Service,Topic: PChar;
            var ServiceHsz, TopicHsz: Hsz; var ConvHdl: HConv): boolean;
var
  o_k: boolean;
begin
  o_k:=false;
  ServiceHsz:=0; TopicHsz:=0; ConvHdl := 0;
  ServiceHSz:= DdeCreateStringHandle(Inst, Service, cp_WinAnsi);
  TopicHSz  := DdeCreateStringHandle(Inst, Topic,   cp_WinAnsi);

  if (ServiceHSz <> 0) and (TopicHSz <> 0) then
  begin
    ConvHdl := DdeConnect(Inst, ServiceHSz, TopicHSz, nil);
    if ConvHdl = 0 then
    begin
	    MessageBox(HWindow, 'Can''t start conversation!',
	                               Application^.Name, mb_IconStop);
    end else o_k:=true;
  end else
  begin  
	  MessageBox(HWindow, 'Can''t create strings!', Application^.Name,
	    mb_IconStop);
  end;
  Connect:=o_k;
end;

procedure TDDEClientWindow.Disconnect(var ServiceHsz, TopicHsz: Hsz;
          var ConvHdl: HConv);
begin
  if ServiceHSz <> 0 then DdeFreeStringHandle(Inst, ServiceHSz);
  if TopicHSz   <> 0 then DdeFreeStringHandle(Inst, TopicHSz);
  if ConvHdl    <> 0 then DdeDisconnect(ConvHdl);
  ServiceHsz:=0; TopicHsz:=0; ConvHdl:=0;
end;

procedure TDDEClientWindow.PokeBtn(var Msg: TMessage);
var
  Service,Topic,Item: array[0..255] of char;
  ServiceHsz, TopicHsz, ItemHsz: Hsz;
  ConvHdl    : HConv;
  DataOK: HDDEData;
  TLen,DataLen: integer;
  Buf: PChar;
  IsString,IsByte,IsInteger,IsWord,IsLong,IsHex,IsDecimal,IsBinary: boolean;
  IsError,IsNegative: boolean;
  Allow: set of char;
  digit,i,basis: integer;
  lnum: longint;
  wnum: word;
  inum: integer;
  bnum: byte;
  SS: array[0..255] of char;
  S: string;
begin
  GetDlgItemText(HWindow,dl_ServiceEBox,Service,255);
  GetDlgItemText(HWindow,dl_TopicEBox,Topic,255);
  GetDlgItemText(HWindow,dl_PokeItemEBox,Item,255);

  IsString:=SendDlgItemMsg(dl_StringRBox,bm_GetCheck,0,0)=bf_Checked;
  IsByte:=SendDlgItemMsg(dl_byteRBox,bm_GetCheck,0,0)=bf_Checked;
  IsInteger:=SendDlgItemMsg(dl_IntegerRBox,bm_GetCheck,0,0)=bf_Checked;
  IsWord:=SendDlgItemMsg(dl_WordRBox,bm_GetCheck,0,0)=bf_Checked;
  IsLong:=SendDlgItemMsg(dl_LongRBox,bm_GetCheck,0,0)=bf_Checked;

  IsDecimal:=SendDlgItemMsg(dl_DecimalRBox,bm_GetCheck,0,0)=bf_Checked;
  IsHex:=SendDlgItemMsg(dl_HexRBox,bm_GetCheck,0,0)=bf_Checked;
  IsBinary:=SendDlgItemMsg(dl_BinaryRBox,bm_GetCheck,0,0)=bf_Checked;

  if not connect(Service,Topic,ServiceHsz,TopicHsz,ConvHdl) then
  begin
    Disconnect(ServiceHsz,TopicHsz,ConvHdl); Exit;
  end;
  ItemHSz := DdeCreateStringHandle(Inst, Item,   cp_WinAnsi);

  Tlen:=GetWindowTextLength(GetItemHandle(dl_DataEBox));
  GetMem(Buf,TLen+10);
  GetDlgItemText(HWindow,dl_DataEBox,Buf,TLen+1);
  IsError:=false;
  if IsString then DataLen:=TLen+1
  else begin
    s:=StrPas(Buf);
    if (IsHex) and (Copy(S,1,2)='0x') then Delete(s,1,2);
    i:=0;
    while (i<length(S)) do
    begin
      inc(i);
      if s[i] in [' ',','] then delete(S,i,1)
      else s[i]:=UpCase(S[i]);
    end;
    IsNegative:=false;
    if (S<>'') and (S[1]='-') then
    begin
      if IsInteger then
      begin
        IsNegative:=true; Delete(S,1,1);
      end else IsError:=true;
    end;
    if IsHex then
    begin
      Basis:=16; Allow:=['0'..'9','A'..'F'];
    end else if IsDecimal then
    begin
      Basis:=10; Allow:=['0'..'9'];
    end else if IsBinary then
    begin
      Basis:=2; Allow:=['0','1'];
    end;
    lnum:=0;
    for i:=1 to length(s) do
    if s[i] in allow then
    begin
      if s[i] in ['0'..'9'] then digit:=Ord(s[i])-Ord('0')
      else digit:=Ord(s[i])-ord('A')+10;
      lnum:=lnum*Basis+digit;
    end else IsError:=true;
    if IsNegative then lnum:=-lnum;
    if IsLong then
    begin
      move(lnum,Buf^,sizeof(longint)); DataLen:=sizeof(longint);
    end else if IsWord then
    begin
      if lnum>$FFFF then IsError:=true
      else begin
        wnum:=lnum; move(wnum,Buf^,sizeof(word)); DataLen:=sizeof(word);
      end;
    end else if IsInteger then
    begin
      if (lnum>32767) or (lnum<-32767) then IsError:=true
      else begin
        inum:=lnum; move(inum,Buf^,sizeof(integer)); DataLen:=sizeof(integer);
      end;
    end else if IsByte then
    begin
      if (lnum>$FF) or (lnum<0) then IsError:=true
      else begin
        bnum:=lnum; move(bnum,Buf^,sizeof(byte)); DataLen:=sizeof(byte);
      end;
    end;
  end;
  if IsError then
       MessageBox(HWindow,'Data Error',Nil,mb_IconExclamation
          or mb_ok or mb_TaskModal)
  else begin
    DataOK:=DdeClientTransaction(Buf,DataLen,ConvHdl,ItemHsz,
             cf_Text,Xtyp_Poke,DdeTimeout,Nil);
    if (Word(DataOK)=0) or (DdeGetLastError(Inst)<>DMLERR_No_ERROR) then
    begin
      StrPCopy(SS,'Execution error '+DdeError(Inst)+'!');
         MessageBox(HWindow,SS,Nil,mb_IconExclamation
            or mb_ok or mb_TaskModal);
    end;
  end;

  FreeMem(Buf,TLen+10);
  DdeFreeStringHandle(Inst, ItemHSz);
  Disconnect(ServiceHsz,TopicHsz,ConvHdl);
end;                             { TDDEClientWindow.PokeBtn }

procedure TDDEClientWindow.RequestBtn(var Msg: TMessage);
var
  Service,Topic,Item: array[0..255] of char;
  l,lnum: longint;
  ServiceHsz, TopicHsz, ItemHsz: Hsz;
  ConvHdl    : HConv;
  Data: HDDEData;
  F,F1: PChar;
  S: string;
  pre: string[1];
  SS: array[0..255] of char;
  IsString,IsByte,IsInteger,IsWord,IsLong,IsHex,IsDecimal,IsBinary: boolean;
  i,ndigits,onedigit,Basis: integer;
  ch: char;
begin
  GetDlgItemText(HWindow,dl_ServiceEBox,Service,255);
  GetDlgItemText(HWindow,dl_TopicEBox,Topic,255);
  GetDlgItemText(HWindow,dl_ReqItemEBox,Item,255);

  if not connect(Service,Topic,ServiceHsz,TopicHsz,ConvHdl) then
  begin
    Disconnect(ServiceHsz,TopicHsz,ConvHdl); Exit;
  end;
  ItemHSz := DdeCreateStringHandle(Inst, Item,   cp_WinAnsi);
  Data:=DDEClientTransaction(Nil,0,ConvHdl,ItemHsz,
             cf_Text,Xtyp_Request,DdeTimeout,Nil);
  if (Word(Data)=0) or (DdeGetLastError(Inst)<>DMLERR_No_ERROR) then
  begin
    StrPCopy(SS,'Execution error '+DdeError(Inst)+'!');
       MessageBox(HWindow,SS,Nil,mb_IconExclamation
          or mb_ok or mb_TaskModal);
    StrPCopy(Item,'');
    SetDlgItemText(Hwindow,dl_DataEBox,Item);
  end else
  begin
    IsString:=SendDlgItemMsg(dl_StringRBox,bm_GetCheck,0,0)=bf_Checked;
    IsByte:=SendDlgItemMsg(dl_byteRBox,bm_GetCheck,0,0)=bf_Checked;
    IsInteger:=SendDlgItemMsg(dl_IntegerRBox,bm_GetCheck,0,0)=bf_Checked;
    IsWord:=SendDlgItemMsg(dl_WordRBox,bm_GetCheck,0,0)=bf_Checked;
    IsLong:=SendDlgItemMsg(dl_LongRBox,bm_GetCheck,0,0)=bf_Checked;

    IsDecimal:=SendDlgItemMsg(dl_DecimalRBox,bm_GetCheck,0,0)=bf_Checked;
    IsHex:=SendDlgItemMsg(dl_HexRBox,bm_GetCheck,0,0)=bf_Checked;
    IsBinary:=SendDlgItemMsg(dl_BinaryRBox,bm_GetCheck,0,0)=bf_Checked;

    F:=DdeAccessData(Data,@l);
    if IsString then
    begin
      GetMem(F1,l+1);
      Move(F^,F1^,l); F1[l]:=#0;
      SetDlgItemText(HWindow,dl_DataEBox,F1);
    end else
    begin
      lnum:=0; StrPCopy(Ss,'');
      if (IsHex or IsBinary) and IsInteger then
      begin
        IsInteger:=false; IsWord:=true;
      end;
      if IsByte         then lnum:=PByte(F)^
      else if IsInteger then lnum:=PInteger(F)^
      else if IsWord    then lnum:=PWord(F)^
      else if IsLong    then lnum:=PLongint(F)^;
      if IsHex then
      begin
        S:=''; NDigits:=0; pre:='';
        if IsByte then NDigits:=2;
        if IsWord then NDigits:=4;
        if IsLong then NDigits:=8;
        if (lnum<0) and IsLong then
        begin
          pre:='F'; dec(ndigits);
          lnum:=lnum and $7FFFFFFF;
        end;
        for i:=1 to ndigits do
        begin
          OneDigit:=lnum mod 16; lnum:=lnum div 16;
          if OneDigit<10 then ch:=Chr(Ord('0')+OneDigit)
          else ch:=Chr(Ord('A')+OneDigit-10);
          if i=5 then S:=' '+S;
          S:=ch+S;
        end;
        StrPCopy(Ss,'0x'+pre+S);
      end else if IsBinary then
      begin
        S:=''; NDigits:=0; pre:='';
        if IsByte then NDigits:=8;
        if IsWord then NDigits:=16;
        if IsLong then NDigits:=32;
        if (lnum<0) and IsLong then
        begin
          pre:='1'; dec(ndigits);
          lnum:=lnum and $7FFFFFFF;
        end;
        for i:=0 to ndigits-1 do
        begin
          OneDigit:=lnum mod 2; lnum:=lnum div 2;
          ch:=Chr(Ord('0')+OneDigit);
          if (i>0) and (i mod 4=0) then S:=' '+S;
          S:=ch+S;
        end;
        StrPCopy(Ss,pre+S);
      end else StrPCopy(Ss,num2str(lnum));
      SetDlgItemText(HWindow,dl_DataEBox,Ss);
    end;
    DdeUnAccessData(Data);
    DdeFreeDataHandle(Data);
  end;

  DdeFreeStringHandle(Inst, ItemHSz);
  Disconnect(ServiceHsz,TopicHsz,ConvHdl);
end;

procedure TDDEClientWindow.ExecuteBtn(var Msg: TMessage);
var
  Command: array[0..1023] of char;
  Service,Topic,F: array[0..255] of char;
  l: longint;
  ServiceHsz, TopicHsz, CommandHsz: Hsz;
  ConvHdl    : HConv;
  Cmd: HDDEData;
  S: string;
begin
  GetDlgItemText(HWindow,dl_ServiceEBox,Service,255);
  GetDlgItemText(HWindow,dl_TopicEBox,Topic,255);
  GetDlgItemText(HWindow,dl_MacroEBox,Command,1023);

  if not connect(Service,Topic,ServiceHsz,TopicHsz,ConvHdl) then
  begin
    Disconnect(ServiceHsz,TopicHsz,ConvHdl); Exit;
  end;
  if DDEClientTransaction(@Command,StrLen(Command)+1,ConvHdl,
             0,cf_Text,Xtyp_Execute,DdeTimeout,Nil)=0 then
  begin
    StrPCopy(F,'Execution error '+DdeError(Inst)+'!');
       MessageBox(HWindow,F,Nil,mb_IconExclamation
          or mb_ok or mb_TaskModal);
  end;

  Disconnect(ServiceHsz,TopicHsz,ConvHdl);

end;

procedure TDDEClientWindow.EnableHex;
var
  ToEnable: boolean;
begin
  ToEnable:= (SendDlgItemMsg(dl_StringRBox,bm_GetCheck,0,0)=bf_UnChecked) and
             (SendDlgItemMsg(dl_IntegerRBox,bm_GetCheck,0,0)=bf_UnChecked);
  EnableWindow(GetItemHandle(dl_DecimalRbox),ToEnable);
  EnableWindow(GetItemHandle(dl_HexRbox),ToEnable);
  EnableWindow(GetItemHandle(dl_BinaryRbox),ToEnable);
end;

procedure TDDEClientWindow.StrSelect(var Msg: TMessage);
begin EnableHex; end;

procedure TDDEClientWindow.ByteSelect(var Msg: TMessage);
begin EnableHex; end;

procedure TDDEClientWindow.IntegerSelect(var Msg: TMessage);
begin EnableHex; end;

procedure TDDEClientWindow.WordSelect(var Msg: TMessage);
begin EnableHex; end;

procedure TDDEClientWindow.LongSelect(var Msg: TMessage);
begin EnableHex; end;

procedure TDDEClientWindow.ok(var Msg: TMessage);
begin end;

procedure TDDEClientWindow.wmDestroy(var Msg: TMessage);
begin
  WinHelp(HWindow,HelpFile,Help_Quit,0);
  TDlgWindow.wmDestroy(Msg);
end;


{ TDDEClientApp Methods }

{ Constructs an instance of the DDE Client Window and installs it as the
  MainWindow of this application.
}

procedure TDDECLientApp.InitInstance;
var
  Path: array[0..fsPathName] of char;
  Dir: array[0..fsDirectory] of Char;
  fName: array[0..fsFileName] of Char;
  Ext: array[0..fsExtension] of Char;
begin
  StrPCopy(Path,ParamStr(0));
  FileSplit(Path,Dir,fName,Ext);
  StrPCopy(IniFile,StrPas(Dir)+StrPas(fName)+'.INI');
  StrPCopy(HelpFile,StrPas(Dir)+StrPas(fName)+'.HLP');
  TApplication.InitInstance;
  HAccTable:=LoadAccelerators(Hinstance,PChar(rc_Accel));
end;

procedure TDDEClientApp.InitMainWindow;
begin
  MainWindow := New(PDDEClientWindow, Init(nil, PChar(rc_MainWindow)));
end;

function TDDEClientApp.ProcessAppMsg(var Message: TMsg): Boolean;
begin
  ProcessAppMsg := ProcessAccels(Message) or ProcessDlgMsg(Message);
end;



{ Main program }

begin
  Ctl3dRegister(HInstance);
  Ctl3dAutoSubclass(HInstance);
  MainIcon:=LoadIcon(HInstance,PChar(rc_MainIcon));

  GetMem(Buf0,BufSize);
  App.Init('DDETest');
  App.Run;
  App.Done;
  FreeMem(Buf0,BufSize);

  DestroyIcon(MainIcon);
  Ctl3dUnregister(HInstance);
end.



