/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.installer.container.impl.GUIInstallerContainer;
import com.izforge.izpack.installer.gui.InstallerController;
import com.izforge.izpack.installer.gui.SplashScreen;
import com.izforge.izpack.installer.language.LanguageDialog;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class InstallerGui {
    private static final Logger logger = Logger.getLogger(InstallerGui.class.getName());

    public static void run(final String langCode, final String mediaPath) throws Exception {
        final GUIInstallerContainer applicationComponent = new GUIInstallerContainer();
        final Container installerContainer = applicationComponent.getComponent(Container.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SplashScreen splashScreen = installerContainer.getComponent(SplashScreen.class);
                    splashScreen.displaySplashScreen();
                    if (mediaPath != null) {
                        InstallData installData = applicationComponent.getComponent(InstallData.class);
                        installData.setMediaPath(mediaPath);
                    }
                    InstallerController controller = installerContainer.getComponent(InstallerController.class);
                    splashScreen.removeSplashScreen();
                    if (langCode == null) {
                        installerContainer.getComponent(LanguageDialog.class).initLangPack();
                    } else {
                        installerContainer.getComponent(LanguageDialog.class).propagateLocale(langCode);
                    }
                    if (!installerContainer.getComponent(RequirementsChecker.class).check()) {
                        logger.info("Not all installer requirements are fulfilled.");
                        installerContainer.getComponent(Housekeeper.class).shutDown(-1);
                    }
                    controller.buildInstallation().launchInstallation();
                }
                catch (Exception e) {
                    throw new IzPackException(e);
                }
            }
        });
    }
}

