/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor.hover;

import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.editor.hover.TexHoverControlCreator;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class TexHover
implements ITextHover,
ITextHoverExtension {
    TexEditor editor;
    TexHoverControlCreator creator;

    public TexHover(TexEditor editor) {
        this.editor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            return textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        try {
            int lineNr = textViewer.getDocument().getLineOfOffset(offset);
            int lOffset = textViewer.getDocument().getLineOffset(lineNr);
            String line = textViewer.getDocument().get(lOffset, textViewer.getDocument().getLineLength(lineNr));
            int start = offset - lOffset;
            IRegion r = LatexParserUtils.getCommand(line, start);
            if (r == null) {
                return new Region(offset, 0);
            }
            IRegion rArg = LatexParserUtils.getCommandArgument(line, r.getOffset());
            if (rArg == null) {
                return new Region(lOffset + r.getOffset(), r.getLength());
            }
            String command = line.substring(r.getOffset() + 1, r.getOffset() + r.getLength());
            if (command.indexOf("cite") >= 0 && start > r.getOffset() + r.getLength()) {
                int cEnd = rArg.getOffset() + rArg.getLength();
                int regionStart = line.lastIndexOf(44, start) < line.lastIndexOf(123, start) ? line.lastIndexOf(123, start) + 1 : line.lastIndexOf(44, start) + 1;
                int lastComma = line.indexOf(44, start);
                if (lastComma >= 0 && lastComma < cEnd) {
                    return new Region(lOffset + regionStart, lastComma - regionStart);
                }
                return new Region(lOffset + regionStart, cEnd - regionStart);
            }
            int length = rArg.getOffset() - r.getOffset() + rArg.getLength() + 1;
            return new Region(lOffset + r.getOffset(), length);
        }
        catch (BadLocationException badLocationException) {
            return new Region(offset, 0);
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.creator == null) {
            this.creator = new TexHoverControlCreator(this.editor);
        }
        return this.creator;
    }
}

