/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.viewer.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class FileLocationClient {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORTNUMBER = 55000;
    private String hostName;
    private int portNumber;
    private String fileName;
    private int lineNumber;

    public FileLocationClient(String h, int p, String f, int l) {
        this.hostName = h == null || h.length() == 0 ? DEFAULT_HOSTNAME : h;
        this.portNumber = p == -1 ? 55000 : p;
        this.fileName = f;
        this.lineNumber = l;
    }

    public void writeToSocket() {
        try {
            Socket socket = new Socket(this.hostName, this.portNumber);
            PrintWriter out = new PrintWriter(socket.getOutputStream());
            out.println(String.valueOf(this.fileName) + ':' + this.lineNumber);
            out.flush();
            out.close();
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Don't know about host: " + this.hostName);
        }
        catch (IOException iOException) {
            System.out.println("Couldn't get I/O for the connection to: " + this.hostName);
        }
    }

    public static FileLocationClient parseCommandLine(String[] args) {
        String host = null;
        String portNum = null;
        String file = null;
        String lineNum = null;
        int i = 0;
        while (i + 1 < args.length) {
            if (args[i].equals("-p")) {
                portNum = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-h")) {
                host = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-f")) {
                file = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-l")) {
                lineNum = args[i + 1];
                i += 2;
                continue;
            }
            System.out.println("Unknown argument " + args[i]);
            ++i;
        }
        if (file == null) {
            System.out.println("Empty filename");
            return null;
        }
        if (lineNum == null) {
            System.out.println("Empty lineNumber");
            return null;
        }
        int line = -1;
        try {
            line = Integer.parseInt(lineNum);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid lineNumber: " + lineNum);
            return null;
        }
        int port = -1;
        try {
            port = Integer.parseInt(portNum);
        }
        catch (NumberFormatException numberFormatException) {}
        return new FileLocationClient(host, port, file, line);
    }

    public static void main(String[] args) {
        FileLocationClient client = FileLocationClient.parseCommandLine(args);
        if (client != null) {
            client.writeToSocket();
        }
    }
}

