/*
 File: cweave_T_sdc.cpp
 Date and Time: Fri Jan 30 18:55:08 2015 
*/
#include "cweave_T_sdc.h"
using namespace NS_yacco2_T_enum;// enumerate
using namespace NS_yacco2_err_symbols;// error symbols
using namespace NS_yacco2_k_symbols;// lrk 
using namespace NS_yacco2_terminals;// terminals
using namespace NS_yacco2_characters;// rc 
using namespace yacco2;// yacco2 library
using namespace NS_cweave_T_sdc;// grammar's ns
// first set terminals
fsm_rules_reuse_table_type::fsm_rules_reuse_table_type(){
 no_rules_entries_ = 3;
 per_rule_s_table_[0] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[1] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[2] =  new Per_rule_s_reuse_table();
}
  Ccweave_T_sdc::
  Ccweave_T_sdc()
    :yacco2::CAbs_fsm
      ("cweave_T_sdc.lex"
      ,"1.0"
      ,"5 Jan. 2006"
      ,false
      ,"Write out cweave Terminals' sdc directives."
      ,"Fri Jan 30 18:55:08 2015 "
      ,S1_Ccweave_T_sdc){
    
  }
 
Ccweave_T_sdc::~Ccweave_T_sdc(){

  for(int x = 0;x < 3;++x){
   ///delete fsm_rules_reuse_table.per_rule_s_table_[x];
  }
} 

  bool Ccweave_T_sdc::failed(){
      return false;
  }
  void Ccweave_T_sdc::op(){
}
int Ccweave_T_sdc::rhs_to_rules_mapping_[9] = {
 -1
 ,0 // subrule 1 for rule 1
 ,1 // subrule 2 for rule 2
 ,1 // subrule 3 for rule 2
 ,2 // subrule 4 for rule 3
 ,2 // subrule 5 for rule 3
 ,2 // subrule 6 for rule 3
 ,2 // subrule 7 for rule 3
 ,2 // subrule 8 for rule 3
}; 

 	void Ccweave_T_sdc::initialize
		(std::ofstream* Cweave_file
		,yacco2::KCHARP T_name){
			cweave_file_ = Cweave_file;
			T_name_ = T_name;
		}

    void Ccweave_T_sdc::wrt_directive(yacco2::KCHARP Directive,T_syntax_code* Sdc){
      output_sr_sdcode_title(Directive);
      if(Sdc == 0){
        output_sr_sdcode(Directive);
        (*cweave_file_) << "/";
        (*cweave_file_) << "/ no sdcode" << endl;
        return;
      }      
      if(Sdc->cweb_marker() != 0){
        WRT_CWEB_MARKER(cweave_file_,Sdc->cweb_marker());   
	  }
      output_sr_sdcode(Directive);
      string xlate;
      int len = Sdc->syntax_code()->length();
      string& sdc=*Sdc->syntax_code();
      // prescan @ due to cweave reqmts
      for(int x=0;x<len;++x){
        char nc = sdc[x];
        if(nc=='@'){
          // check next char for cweave type directives
          char nnc = sdc[x+1];
          if((nnc == '*') || (nnc == '<') || (nnc == '>')){
            xlate += nc;
             continue;
          }else{
            xlate += "@@";
            continue;
          }			
	}else{
            xlate += nc;
            continue;
	}
      }
      (*cweave_file_) << xlate.c_str() << endl;
    }

    void Ccweave_T_sdc::output_sr_sdcode(yacco2::KCHARP Directive){
	  char big_buf_[BIG_BUFFER_32K];		
char xa[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave
      (T_name_
      ,xa);
      KCHARP cweave_sentence =
        "@<%s %s directive@>=\n";
       
 	  sprintf(big_buf_
 		,cweave_sentence
 		,xa
 		,Directive
 		);
	  (*cweave_file_) << big_buf_;
    }

   void Ccweave_T_sdc::output_sr_sdcode_title(yacco2::KCHARP Directive){
	  char big_buf_[BIG_BUFFER_32K];		
char xa[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave
      (T_name_
      ,xa);
      KCHARP cweave_sentence =
        "@*3 %s %s directive.\n";
       
 	  sprintf(big_buf_
 		,cweave_sentence
 		,xa
 		,Directive
 		);
	  (*cweave_file_) << big_buf_;
    }
  
Rweave_sdc::Rweave_sdc(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rweave_sdc",0,Ccweave_T_sdc::R_Rweave_sdc_,P,false,false){
}

Rdirectives::Rdirectives(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rdirectives",0,Ccweave_T_sdc::R_Rdirectives_,P,false,false){
}

Rdirective::Rdirective(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rdirective",0,Ccweave_T_sdc::R_Rdirective_,P,false,false){
}

void Rdirective::sr1(){
  struct SF{
   T_user_declaration* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_T_sdc* fsm = (Ccweave_T_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-declaration";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr2(){
  struct SF{
   T_constructor* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_T_sdc* fsm = (Ccweave_T_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "constructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr3(){
  struct SF{
   T_destructor* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_T_sdc* fsm = (Ccweave_T_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "destructor";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr4(){
  struct SF{
   T_op* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_T_sdc* fsm = (Ccweave_T_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "op";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

void Rdirective::sr5(){
  struct SF{
   T_user_implementation* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
      Ccweave_T_sdc* fsm = (Ccweave_T_sdc*)rule_info__.parser__->fsm_tbl__;
      KCHARP sdc = "user-implementation";
      fsm->wrt_directive(sdc,sf->p1__->syntax_code());
    
}

