/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;

public class GrayScale
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -4082255477140195806L;
    private final ColorChannel colorChannel;

    public GrayScale(Matrix matrix, ColorChannel colorChannel) {
        super(matrix);
        this.colorChannel = colorChannel;
    }

    public double getDouble(long ... coordinates) {
        int value = this.getSource().getAsInt(coordinates);
        switch (this.colorChannel) {
            case Red: {
                return (double)(value >> 16 & 0xFF) / 255.0;
            }
            case Green: {
                return (double)(value >> 8 & 0xFF) / 255.0;
            }
        }
        return (double)(value & 0xFF) / 255.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorChannel {
        Red,
        Green,
        Blue;

    }
}

