/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.util.Arrays;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.NonZeroIterable;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseDoubleVector1D
extends AbstractSparseDoubleMatrix2D {
    private static final long serialVersionUID = -2990811989700739834L;
    private static final int initialCapacity = 8;
    private static final double growFactor = 1.5;
    private long[] indices;
    private double[] values;
    private int capacity;
    private int valueCount;
    private boolean transposed;

    public DefaultSparseDoubleVector1D(DefaultSparseDoubleVector1D source) {
        super(source.getRowCount(), source.getColumnCount());
        this.valueCount = source.valueCount;
        this.capacity = source.capacity;
        this.indices = Arrays.copyOf(source.indices, source.indices.length);
        this.values = Arrays.copyOf(source.values, source.values.length);
        this.transposed = this.getColumnCount() > this.getRowCount();
    }

    public DefaultSparseDoubleVector1D(long rows, long columns) {
        super(rows, columns);
        VerifyUtil.verifyTrue(rows == 1L || columns == 1L, "not a vector");
        this.valueCount = 0;
        this.capacity = 8;
        this.indices = new long[8];
        this.values = new double[8];
        this.transposed = columns > rows;
    }

    @Override
    public final void clear() {
        this.valueCount = 0;
    }

    @Override
    public double getDouble(long row, long column) {
        long pos;
        if (this.transposed) {
            VerifyUtil.verifyEquals(row, 0L, "row must be 0");
            pos = column;
        } else {
            VerifyUtil.verifyEquals(column, 0L, "column must be 0");
            pos = row;
        }
        int index = MathUtil.search(this.indices, 0, this.valueCount, pos);
        if (index >= 0) {
            return this.values[index];
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(double value, long row, long column) {
        long pos;
        if (this.transposed) {
            VerifyUtil.verifyEquals(row, 0L, "row must be 0");
            pos = column;
        } else {
            VerifyUtil.verifyEquals(column, 0L, "column must be 0");
            pos = row;
        }
        long[] lArray = this.indices;
        synchronized (this.indices) {
            int index = MathUtil.search(this.indices, 0, this.valueCount, pos);
            if (index >= 0) {
                if (value == 0.0) {
                    System.arraycopy(this.indices, index + 1, this.indices, index, this.valueCount - index - 1);
                    System.arraycopy(this.values, index + 1, this.values, index, this.valueCount - index - 1);
                    --this.valueCount;
                } else {
                    this.values[index] = value;
                }
            } else if (value != 0.0) {
                if (this.capacity == this.valueCount) {
                    this.capacity = (int)((double)this.capacity * 1.5);
                    this.indices = Arrays.copyOf(this.indices, this.capacity);
                    this.values = Arrays.copyOf(this.values, this.capacity);
                }
                if ((index = DefaultSparseDoubleVector1D.findInsertPosition(this.indices, 0, this.valueCount, pos)) != this.capacity) {
                    System.arraycopy(this.indices, index, this.indices, index + 1, this.valueCount - index);
                    System.arraycopy(this.values, index, this.values, index + 1, this.valueCount - index);
                }
                this.indices[index] = pos;
                this.values[index] = value;
                ++this.valueCount;
            }
            // ** MonitorExit[var9_5] (shouldn't be in output)
            return;
        }
    }

    public static final int findInsertPosition(long[] values, int fromIndex, int toIndex, long key) {
        --toIndex;
        while (fromIndex <= toIndex) {
            int mid = fromIndex + toIndex >>> 1;
            long midVal = values[mid];
            if (midVal < key) {
                fromIndex = mid + 1;
                continue;
            }
            if (midVal > key) {
                toIndex = mid - 1;
                continue;
            }
            return mid;
        }
        return fromIndex;
    }

    @Override
    public double getDouble(int row, int column) {
        return this.getDouble((long)row, (long)column);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.setDouble(value, (long)row, (long)column);
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.getDouble(coordinates) != 0.0;
    }

    @Override
    public Matrix divide(double value) {
        DefaultSparseDoubleVector1D result = new DefaultSparseDoubleVector1D(this);
        double[] resultValues = result.values;
        int i = resultValues.length;
        while (--i != -1) {
            int n = i;
            resultValues[n] = resultValues[n] / value;
        }
        return result;
    }

    @Override
    public Matrix times(double value) {
        DefaultSparseDoubleVector1D result = new DefaultSparseDoubleVector1D(this);
        double[] resultValues = result.values;
        int i = resultValues.length;
        while (--i != -1) {
            int n = i;
            resultValues[n] = resultValues[n] * value;
        }
        return result;
    }

    @Override
    public Matrix times(Matrix matrix) {
        DefaultSparseDoubleVector1D result = new DefaultSparseDoubleVector1D(this);
        double[] resultValues = result.values;
        int i = resultValues.length;
        while (--i != -1) {
            int n = i;
            resultValues[n] = resultValues[n] * matrix.getAsDouble(this.indices[i], 0L);
        }
        return result;
    }

    @Override
    public Matrix divide(Matrix matrix) {
        DefaultSparseDoubleVector1D result = new DefaultSparseDoubleVector1D(this);
        double[] resultValues = result.values;
        int i = resultValues.length;
        while (--i != -1) {
            int n = i;
            resultValues[n] = resultValues[n] / matrix.getAsDouble(this.indices[i], 0L);
        }
        return result;
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new NonZeroIterable(this.indices, this.valueCount);
    }
}

