/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ojalgo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.function.implementation.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.LUDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.OjalgoUtil;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.ojalgo.OjalgoDenseDoubleMatrix2DFactory;
import org.ujmp.ojalgo.calculation.Chol;
import org.ujmp.ojalgo.calculation.Eig;
import org.ujmp.ojalgo.calculation.Inv;
import org.ujmp.ojalgo.calculation.InvSPD;
import org.ujmp.ojalgo.calculation.LU;
import org.ujmp.ojalgo.calculation.QR;
import org.ujmp.ojalgo.calculation.SVD;
import org.ujmp.ojalgo.calculation.Solve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OjalgoDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<MatrixStore<Double>> {
    private static final long serialVersionUID = 6628172130438716653L;
    public static final OjalgoDenseDoubleMatrix2DFactory Factory = new OjalgoDenseDoubleMatrix2DFactory();
    private transient PrimitiveDenseStore matrix;

    public OjalgoDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(rows, columns);
    }

    public OjalgoDenseDoubleMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        if (m instanceof HasColumnMajorDoubleArray1D) {
            double[] data = ((HasColumnMajorDoubleArray1D)((Object)m)).getColumnMajorDoubleArray1D();
            this.matrix = OjalgoUtil.linkToArray((int)m.getRowCount(), (int)m.getColumnCount(), data);
        } else if (m instanceof DenseDoubleMatrix2D) {
            this.matrix = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero((int)m.getRowCount(), (int)m.getColumnCount());
            DenseDoubleMatrix2D m2 = (DenseDoubleMatrix2D)m;
            int r = (int)m.getRowCount();
            while (--r >= 0) {
                int c = (int)m.getColumnCount();
                while (--c >= 0) {
                    this.matrix.set(r, c, m2.getDouble(r, c));
                }
            }
        } else {
            this.matrix = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero((int)m.getRowCount(), (int)m.getColumnCount());
            for (long[] c : m.availableCoordinates()) {
                this.setDouble(m.getAsDouble(c), c);
            }
        }
        if (m.getMetaData() != null) {
            this.setMetaData(m.getMetaData().clone());
        }
    }

    public OjalgoDenseDoubleMatrix2D(MatrixStore<Double> m) {
        super((long)m.getRowDim(), (long)m.getColDim());
        this.setWrappedObject(m);
    }

    @Override
    public Matrix chol() {
        return Chol.INSTANCE.calc(this);
    }

    @Override
    public Matrix divide(double factor) {
        PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
        retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.DIVIDE, (Number)factor);
        OjalgoDenseDoubleMatrix2D result = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix divide(Matrix m) {
        if (m instanceof OjalgoDenseDoubleMatrix2D) {
            PrimitiveDenseStore tmpArg = ((OjalgoDenseDoubleMatrix2D)m).getWrappedObject();
            PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
            retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.DIVIDE, (MatrixStore)tmpArg);
            OjalgoDenseDoubleMatrix2D result = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.divide(m);
    }

    @Override
    public Matrix[] eig() {
        return Eig.INSTANCE.calc(this);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.doubleValue(row, column);
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.doubleValue((int)row, (int)column);
    }

    @Override
    public PrimitiveDenseStore getWrappedObject() {
        return this.matrix;
    }

    @Override
    public Matrix inv() {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSPD() {
        return InvSPD.INSTANCE.calc(this);
    }

    @Override
    public double det() {
        org.ojalgo.matrix.decomposition.LU lu = LUDecomposition.makePrimitive();
        lu.compute((Access2D)this.matrix);
        return (Double)lu.getDeterminant();
    }

    @Override
    public Matrix[] lu() {
        return LU.INSTANCE.calc(this);
    }

    @Override
    public Matrix minus(double factor) {
        PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
        retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.SUBTRACT, (Number)factor);
        return new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof OjalgoDenseDoubleMatrix2D) {
            PrimitiveDenseStore tmpArg = ((OjalgoDenseDoubleMatrix2D)m).getWrappedObject();
            PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
            retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.SUBTRACT, (MatrixStore)tmpArg);
            OjalgoDenseDoubleMatrix2D result = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.minus(m);
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof OjalgoDenseDoubleMatrix2D) {
            PrimitiveDenseStore mo = ((OjalgoDenseDoubleMatrix2D)m).getWrappedObject();
            PrimitiveDenseStore result = (PrimitiveDenseStore)this.matrix.multiplyRight((MatrixStore)mo);
            return new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)result);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix plus(double factor) {
        PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
        retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.ADD, (Number)factor);
        OjalgoDenseDoubleMatrix2D result = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof OjalgoDenseDoubleMatrix2D) {
            PrimitiveDenseStore tmpArg = ((OjalgoDenseDoubleMatrix2D)m).getWrappedObject();
            PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
            retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.ADD, (MatrixStore)tmpArg);
            OjalgoDenseDoubleMatrix2D result = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(m);
    }

    @Override
    public Matrix[] qr() {
        return QR.INSTANCE.calc(this);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row, column, value);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set((int)row, (int)column, value);
    }

    public void setWrappedObject(MatrixStore<Double> object) {
        this.matrix = object instanceof PrimitiveDenseStore ? (PrimitiveDenseStore)object : (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.copy(object);
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix[] svd() {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public Matrix times(double factor) {
        PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
        retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.MULTIPLY, (Number)factor);
        OjalgoDenseDoubleMatrix2D result = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix times(Matrix m) {
        if (m instanceof OjalgoDenseDoubleMatrix2D) {
            PrimitiveDenseStore tmpArg = ((OjalgoDenseDoubleMatrix2D)m).getWrappedObject();
            PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero((int)this.getRowCount(), (int)this.getColumnCount());
            retVal.fillMatching((MatrixStore)this.matrix, PrimitiveFunction.MULTIPLY, (MatrixStore)tmpArg);
            OjalgoDenseDoubleMatrix2D result = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)retVal);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.times(m);
    }

    @Override
    public double[][] toDoubleArray() {
        return ArrayUtils.toRawCopyOf((Access2D)this.matrix);
    }

    @Override
    public Matrix transpose() {
        return new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)this.matrix.transpose());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] data = (double[][])s.readObject();
        this.matrix = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.copy(ArrayUtils.wrapAccess2D((double[][])data));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.toDoubleArray());
    }

    public OjalgoDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

