/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.poi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.ujmp.core.objectmatrix.DenseObjectMatrix2D;
import org.ujmp.poi.AbstractMatrixExcelImporter;

public class MatrixXLSImporter
extends AbstractMatrixExcelImporter {
    public DenseObjectMatrix2D importFromXLS(File file, int sheetNumber) throws InvalidFormatException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        DenseObjectMatrix2D matrix = this.importFromXLS(bufferedInputStream, sheetNumber);
        bufferedInputStream.close();
        fileInputStream.close();
        return matrix;
    }

    public DenseObjectMatrix2D importFromXLS(String filename, int sheetNumber) throws InvalidFormatException, IOException {
        return this.importFromXLS(new File(filename), sheetNumber);
    }

    public DenseObjectMatrix2D importFromXLS(InputStream inputStream, int sheetNumber) throws InvalidFormatException, IOException {
        HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
        return this.importFromWorkbook((Workbook)workbook, sheetNumber);
    }
}

