/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.HypergeometricProbability;

public class JEASEStatistics {
    public String population_file_name = "";
    public String list_file_name = "";
    public String output_file_name;
    public Vector annotation_file_names = new Vector();
    public int population_total;
    public int list_total;
    public Hashtable categories = new Hashtable();
    public Hashtable categories_population = new Hashtable();
    public Hashtable categories_list = new Hashtable();
    public Hashtable hitAccumulator = new Hashtable();
    public HypergeometricProbability hgp_computation = new HypergeometricProbability();
    public BufferedReader read_in_stream;
    public String[][] records;
    public String[] categoryNames;
    public String[][] listHitMatrix;
    public String[] orders;
    public boolean reportEaseScore = true;
    private Hashtable pop_totals = new Hashtable();
    private Hashtable sample_totals = new Hashtable();
    private String sep;

    public JEASEStatistics() {
        this.population_total = 0;
        this.list_total = 0;
        this.sep = System.getProperty("file.separator");
    }

    public JEASEStatistics(boolean bl) {
        this.reportEaseScore = bl;
        this.population_total = 0;
        this.list_total = 0;
        this.sep = System.getProperty("file.separator");
    }

    public void UseNewPopulationFileName(String string) {
        this.population_file_name = string;
    }

    public void RemoveCurrentAnnotationFileNames() {
        this.annotation_file_names.removeAllElements();
    }

    public void AddAnnotationFileName(String string) {
        this.annotation_file_names.addElement(string);
    }

    public void UseNewListFileName(String string) {
        this.list_file_name = string;
    }

    public void SetOutputFileName(String string) {
        this.output_file_name = string;
    }

    public void GetCategories() {
        BufferedReader bufferedReader = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        try {
            int n;
            int n2;
            String string4;
            Object object = this.annotation_file_names.elements();
            while (object.hasMoreElements()) {
                string3 = object.nextElement().toString();
                bufferedReader = new BufferedReader(new FileReader(string3));
                string4 = string3.substring(string3.lastIndexOf(this.sep) + 1, string3.lastIndexOf("."));
                this.sample_totals.put(string4, new Hashtable());
                this.pop_totals.put(string4, new Hashtable());
                while ((string = bufferedReader.readLine()) != null) {
                    n2 = string.indexOf("\t");
                    if (n2 >= string.length() || n2 < 1) continue;
                    int n3 = string.indexOf("\t", n2 + 1);
                    if (n3 >= string.length() || n3 < 1) {
                        n3 = string.length();
                    }
                    if (!this.categories.containsKey(string2 = string4 + "\t" + string.substring(n2 + 1, n3).trim())) {
                        this.categories.put(string2, new Hashtable());
                        ((Hashtable)this.categories.get(string2)).put(string.substring(0, n2).trim(), "");
                        continue;
                    }
                    ((Hashtable)this.categories.get(string2)).put(string.substring(0, n2).trim(), "");
                }
            }
            for (n = 0; n < this.annotation_file_names.size(); ++n) {
                object = (String)this.annotation_file_names.elementAt(n);
                int n4 = ((String)object).lastIndexOf(this.sep);
                String string5 = ((String)object).substring(0, n4) + "\\Implies\\";
                File file = new File(string5 = string5 + ((String)object).substring(n4 + 1, ((String)object).length()));
                if (!file.exists() || !file.isFile()) continue;
                bufferedReader = new BufferedReader(new FileReader(string5));
                string4 = ((String)object).substring(((String)object).lastIndexOf(this.sep) + 1, ((String)object).lastIndexOf("."));
                while ((string = bufferedReader.readLine()) != null) {
                    n2 = string.indexOf(9);
                    if (n2 >= string.length() || n2 < 1) continue;
                    if (!hashtable2.containsKey(string4 + "\t" + string.substring(0, n2).trim())) {
                        hashtable2.put(string4 + "\t" + string.substring(0, n2).trim(), new Vector());
                        ((Vector)hashtable2.get(string4 + "\t" + string.substring(0, n2).trim())).addElement(string4 + "\t" + string.substring(n2, string.length()).trim());
                        continue;
                    }
                    ((Vector)hashtable2.get(string4 + "\t" + string.substring(0, n2).trim())).addElement(string4 + "\t" + string.substring(n2, string.length()).trim());
                }
            }
            n = 0;
            for (int i = 0; i < 10 && n == 0; ++i) {
                String string6 = "";
                n = 1;
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    string6 = (String)enumeration.nextElement();
                    if (!this.categories.containsKey(string6)) continue;
                    Hashtable hashtable3 = (Hashtable)this.categories.get(string6);
                    Vector vector = (Vector)hashtable2.get(string6);
                    for (int j = 0; j < vector.size(); ++j) {
                        Enumeration enumeration2;
                        String string7 = (String)vector.elementAt(j);
                        if (!this.categories.containsKey(string7)) {
                            n = 0;
                            this.categories.put(string7, new Hashtable());
                            enumeration2 = hashtable3.keys();
                            while (enumeration2.hasMoreElements()) {
                                ((Hashtable)this.categories.get(string7)).put((String)enumeration2.nextElement(), "");
                            }
                            continue;
                        }
                        enumeration2 = hashtable3.keys();
                        while (enumeration2.hasMoreElements()) {
                            String string8 = (String)enumeration2.nextElement();
                            if (((Hashtable)this.categories.get(string7)).containsKey(string8)) continue;
                            ((Hashtable)this.categories.get(string7)).put(string8, "");
                            n = 0;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error occured collecting categories");
            System.out.println(exception.getMessage());
        }
    }

    public void GetPopulationHitsByCategory() {
        BufferedReader bufferedReader = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.population_file_name));
            while ((string = bufferedReader.readLine()) != null) {
                hashtable.put(string.trim(), "");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                Enumeration enumeration2 = this.categories.keys();
                while (enumeration2.hasMoreElements()) {
                    string4 = (String)enumeration2.nextElement();
                    hashtable2 = (Hashtable)this.categories.get(string4);
                    if (!hashtable2.containsKey(string5)) continue;
                    if (!this.categories_population.containsKey(string4)) {
                        this.categories_population.put(string4, "1");
                    } else {
                        string3 = String.valueOf(Integer.parseInt((String)this.categories_population.get(string4)) + 1);
                        this.categories_population.put(string4, string3);
                    }
                    hashtable3.put(string5, "");
                }
            }
            this.population_total = hashtable3.size();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void GetListHitsByCategory() {
        BufferedReader bufferedReader = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.list_file_name));
            while ((string = bufferedReader.readLine()) != null) {
                hashtable.put(string.trim(), "");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                Enumeration enumeration2 = this.categories.keys();
                while (enumeration2.hasMoreElements()) {
                    string4 = (String)enumeration2.nextElement();
                    hashtable2 = (Hashtable)this.categories.get(string4);
                    if (!hashtable2.containsKey(string5)) continue;
                    if (!this.categories_list.containsKey(string4)) {
                        this.categories_list.put(string4, "1");
                    } else {
                        string3 = String.valueOf(Integer.parseInt((String)this.categories_list.get(string4)) + 1);
                        this.categories_list.put(string4, string3);
                    }
                    hashtable3.put(string5, "");
                }
            }
            this.list_total = hashtable3.size();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void ConstructResults() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        this.records = new String[this.categories_list.size()][7];
        this.orders = new String[this.categories_list.size()];
        int n = 0;
        Enumeration enumeration = this.categories_list.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = "";
            string3 = "";
            string4 = string.substring(0, string.indexOf(9)).trim();
            this.records[n][0] = string4.substring(string4.lastIndexOf(this.sep) + 1).trim();
            this.records[n][1] = string.substring(string.indexOf(9)).trim();
            this.records[n][2] = string2 = (String)this.categories_list.get(string);
            this.list_total = ((Hashtable)this.sample_totals.get(string4)).size();
            this.records[n][3] = String.valueOf(this.list_total);
            this.records[n][4] = this.categories_population.containsKey(string) ? (string3 = (String)this.categories_population.get(string)) : "";
            this.population_total = ((Hashtable)this.pop_totals.get(string4)).size();
            this.records[n][5] = String.valueOf(this.population_total);
            if (!string2.equals("") && !string3.equals("")) {
                double d = this.reportEaseScore ? (Integer.parseInt(string2) > 1 ? this.hgp_computation.SumHGP(this.population_total, Integer.parseInt(string3), this.list_total - 1, Integer.parseInt(string2) - 1) : 1.0) : this.hgp_computation.SumHGP(this.population_total, Integer.parseInt(string3), this.list_total, Integer.parseInt(string2));
                this.records[n][6] = String.valueOf(d);
            } else {
                this.records[n][6] = "1.0";
            }
            ++n;
        }
        this.categoryNames = new String[this.hitAccumulator.size()];
        this.listHitMatrix = new String[this.categoryNames.length][];
        int n2 = 0;
        Enumeration enumeration2 = this.hitAccumulator.keys();
        while (enumeration2.hasMoreElements()) {
            String string5;
            this.categoryNames[n2] = string5 = (String)enumeration2.nextElement();
            Vector vector = (Vector)this.hitAccumulator.get(string5);
            this.listHitMatrix[n2] = new String[vector.size()];
            for (int i = 0; i < this.listHitMatrix[n2].length; ++i) {
                this.listHitMatrix[n2][i] = (String)vector.elementAt(i);
            }
            ++n2;
        }
    }

    public void SortRecords() {
        int n = this.records.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n - 1 - i; ++j) {
                BigDecimal bigDecimal = new BigDecimal(this.records[j][6]);
                BigDecimal bigDecimal2 = new BigDecimal(this.records[j + 1][6]);
                if (bigDecimal.compareTo(bigDecimal2) <= 0) continue;
                String string = this.records[j][0];
                this.records[j][0] = this.records[j + 1][0];
                this.records[j + 1][0] = string;
                string = this.records[j][1];
                this.records[j][1] = this.records[j + 1][1];
                this.records[j + 1][1] = string;
                string = this.records[j][2];
                this.records[j][2] = this.records[j + 1][2];
                this.records[j + 1][2] = string;
                string = this.records[j][3];
                this.records[j][3] = this.records[j + 1][3];
                this.records[j + 1][3] = string;
                string = this.records[j][4];
                this.records[j][4] = this.records[j + 1][4];
                this.records[j + 1][4] = string;
                string = this.records[j][5];
                this.records[j][5] = this.records[j + 1][5];
                this.records[j + 1][5] = string;
                string = this.records[j][6];
                this.records[j][6] = this.records[j + 1][6];
                this.records[j + 1][6] = string;
            }
        }
    }

    public void DisplayResults() {
        try {
            File file = new File(this.output_file_name);
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < this.records.length; ++i) {
                System.out.print(this.records[i][0] + "\t");
                fileWriter.write(this.records[i][0] + "\t");
                System.out.print(this.records[i][1] + "\t");
                fileWriter.write(this.records[i][1] + "\t");
                System.out.print(this.records[i][2] + "\t");
                fileWriter.write(this.records[i][2] + "\t");
                System.out.print(this.records[i][3] + "\t");
                fileWriter.write(this.records[i][3] + "\t");
                System.out.print(this.records[i][4] + "\t");
                fileWriter.write(this.records[i][4] + "\t");
                System.out.println(this.records[i][5] + "\t");
                fileWriter.write(this.records[i][5] + "\t");
                fileWriter.write("\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        JEASEStatistics jEASEStatistics = new JEASEStatistics();
        System.out.println(new Date(System.currentTimeMillis()));
        jEASEStatistics.UseNewPopulationFileName("C:/01_Work_Test_4/Files/JStatistics/All Homo sapiens.txt");
        jEASEStatistics.RemoveCurrentAnnotationFileNames();
        jEASEStatistics.AddAnnotationFileName("C:/01_Work_Test_4/Files/JStatistics/GO Biological Process.txt");
        jEASEStatistics.UseNewListFileName("C:/01_Work_Test_4/Files/JStatistics/Bigger_HepC_chimp.txt");
        jEASEStatistics.SetOutputFileName("C:/del.txt");
        jEASEStatistics.GetCategories();
        jEASEStatistics.GetListHitsByCategory();
        jEASEStatistics.GetPopulationHitsByCategory();
        jEASEStatistics.ConstructResults();
        jEASEStatistics.SortRecords();
        System.out.println(new Date(System.currentTimeMillis()));
        System.out.println("\nCompleted.");
    }

    public void GetPopulationHitsByCategory(Vector vector) {
        Object var2_2 = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        try {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                hashtable.put((String)vector.elementAt(i), "");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                Enumeration enumeration2 = this.categories.keys();
                while (enumeration2.hasMoreElements()) {
                    string3 = (String)enumeration2.nextElement();
                    hashtable2 = (Hashtable)this.categories.get(string3);
                    if (!hashtable2.containsKey(string4)) continue;
                    if (!this.categories_population.containsKey(string3)) {
                        this.categories_population.put(string3, "1");
                    } else {
                        string2 = String.valueOf(Integer.parseInt((String)this.categories_population.get(string3)) + 1);
                        this.categories_population.put(string3, string2);
                    }
                    hashtable3.put(string4, "");
                    string3 = string3.substring(0, string3.indexOf("\t")).trim();
                    ((Hashtable)this.pop_totals.get(string3)).put(string4, "");
                }
            }
            this.population_total = hashtable3.size();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void GetListHitsByCategory(Vector vector) {
        Object var2_2 = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        boolean bl = false;
        try {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                hashtable.put((String)vector.elementAt(i), "");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                Enumeration enumeration2 = this.categories.keys();
                while (enumeration2.hasMoreElements()) {
                    string3 = (String)enumeration2.nextElement();
                    hashtable2 = (Hashtable)this.categories.get(string3);
                    if (!hashtable2.containsKey(string4)) continue;
                    if (!this.categories_list.containsKey(string3)) {
                        this.categories_list.put(string3, "1");
                        this.hitAccumulator.put(string3, new Vector());
                        ((Vector)this.hitAccumulator.get(string3)).add(string4);
                    } else {
                        string2 = String.valueOf(Integer.parseInt((String)this.categories_list.get(string3)) + 1);
                        this.categories_list.put(string3, string2);
                        ((Vector)this.hitAccumulator.get(string3)).add(string4);
                    }
                    hashtable3.put(string4, "");
                    string3 = string3.substring(0, string3.indexOf("\t")).trim();
                    ((Hashtable)this.sample_totals.get(string3)).put(string4, "");
                }
            }
            this.list_total = hashtable3.size();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    String[][] getResults() {
        return this.records;
    }

    String[][] getSurveyResults() {
        return this.records;
    }

    String[][] getListHitMatrix() {
        return this.listHitMatrix;
    }

    String[] getCategoryNames() {
        return this.categoryNames;
    }

    public void resetForNewList() {
        this.categories_list = new Hashtable();
        this.sample_totals = new Hashtable();
        Enumeration enumeration = this.annotation_file_names.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = string.substring(string.lastIndexOf(this.sep) + 1, string.lastIndexOf("."));
            this.sample_totals.put(string2, new Hashtable());
        }
    }

    public void GetPopulationHitsByCategoryForSurvey(Vector vector) {
        Object var2_2 = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        String string4 = "";
        boolean bl = false;
        try {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                hashtable.put((String)vector.elementAt(i), "");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                Enumeration enumeration2 = this.categories.keys();
                while (enumeration2.hasMoreElements()) {
                    string3 = (String)enumeration2.nextElement();
                    hashtable2 = (Hashtable)this.categories.get(string3);
                    if (!hashtable2.containsKey(string5)) continue;
                    if (!this.categories_population.containsKey(string3)) {
                        this.categories_population.put(string3, "1");
                        this.hitAccumulator.put(string3, new Vector());
                        ((Vector)this.hitAccumulator.get(string3)).add(string5);
                    } else {
                        string2 = String.valueOf(Integer.parseInt((String)this.categories_population.get(string3)) + 1);
                        this.categories_population.put(string3, string2);
                        ((Vector)this.hitAccumulator.get(string3)).add(string5);
                    }
                    hashtable3.put(string5, "");
                    string3 = string3.substring(0, string3.indexOf("\t")).trim();
                    ((Hashtable)this.pop_totals.get(string3)).put(string5, "");
                }
            }
            this.population_total = hashtable3.size();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void ConstructSurveyResults() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        this.records = new String[this.categories_population.size()][4];
        this.orders = new String[this.categories_population.size()];
        int n = 0;
        Enumeration enumeration = this.categories_population.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = "";
            string3 = "";
            string4 = string.substring(0, string.indexOf(9)).trim();
            this.records[n][0] = string4.substring(string4.lastIndexOf(this.sep) + 1).trim();
            this.records[n][1] = string.substring(string.indexOf(9)).trim();
            this.records[n][2] = string2 = (String)this.categories_population.get(string);
            this.population_total = ((Hashtable)this.pop_totals.get(string4)).size();
            this.records[n][3] = String.valueOf(this.population_total);
            ++n;
        }
        this.categoryNames = new String[this.hitAccumulator.size()];
        this.listHitMatrix = new String[this.categoryNames.length][];
        int n2 = 0;
        Enumeration enumeration2 = this.hitAccumulator.keys();
        while (enumeration2.hasMoreElements()) {
            String string5;
            this.categoryNames[n2] = string5 = (String)enumeration2.nextElement();
            Vector vector = (Vector)this.hitAccumulator.get(string5);
            this.listHitMatrix[n2] = new String[vector.size()];
            for (int i = 0; i < this.listHitMatrix[n2].length; ++i) {
                this.listHitMatrix[n2][i] = (String)vector.elementAt(i);
            }
            ++n2;
        }
    }
}

