/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.MSigDBSpecies;
import edu.mit.broad.genome.objects.MSigDBVersion;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ChipParser
extends AbstractParser {
    private static final String PROBE_SET_ID = "Probe Set ID";
    private static final String GENE_TITLE = "Gene Title";
    private static final String GENE_SYMBOL = "Gene Symbol";

    public ChipParser() {
        super(Chip.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        Chip chip = (Chip)pob;
        String[] colNames = new String[]{PROBE_SET_ID, GENE_SYMBOL, GENE_TITLE};
        PrintWriter pw = this.startExport(chip, file);
        try {
            for (int i = 0; i < colNames.length; ++i) {
                pw.print(colNames[i]);
                if (i == colNames.length) continue;
                pw.print('\t');
            }
            pw.println();
            for (int r = 0; r < chip.getNumProbes(); ++r) {
                Probe probe = chip.getProbe(r);
                pw.print(probe.getName());
                pw.print('\t');
                Gene gene = probe.getGene();
                String symbol = null;
                String title = null;
                if (gene != null) {
                    symbol = gene.getSymbol();
                    title = gene.getTitle();
                }
                if (symbol == null) {
                    symbol = "NULL";
                }
                if (title == null) {
                    title = "NULL";
                }
                pw.print(symbol);
                pw.print('\t');
                pw.println(title);
            }
        }
        finally {
            this.doneExport();
        }
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        MSigDBVersion msigDBVersion;
        this.startImport(sourcepath);
        String pathLC = sourcepath.toLowerCase();
        if (StringUtils.containsAny((CharSequence)pathLC, (CharSequence[])new CharSequence[]{"ftp.broadinstitute.org", "data.broadinstitute.org", "data.gsea-msigdb.org", "datasets.genepattern.org"})) {
            String versionStr = NamingConventions.extractVersionFromFileName(sourcepath, ".chip");
            MSigDBSpecies msigDBSpecies = versionStr.contains("Mm") ? MSigDBSpecies.Mouse : MSigDBSpecies.Human;
            msigDBVersion = new MSigDBVersion(msigDBSpecies, versionStr);
        } else {
            msigDBVersion = MSigDBVersion.createUnknownTrackingVersion(sourcepath);
        }
        try {
            List list;
            try (BufferedReader bin = new BufferedReader(new InputStreamReader(is));){
                String currLine = this.nextLine(bin);
                List<String> colHeaders = ParseUtils.string2stringsList(currLine, "\t");
                int ps_index = ChipParser.indexOf(PROBE_SET_ID, colHeaders, true);
                int symbol_index = ChipParser.indexOf(GENE_SYMBOL, colHeaders, true);
                int title_index = ChipParser.indexOf(GENE_TITLE, colHeaders, false);
                ArrayList<Probe> probesList = new ArrayList<Probe>();
                currLine = this.nextLine(bin);
                HashSet<String> names = new HashSet<String>();
                HashSet<String> duplicates = new HashSet<String>();
                while (currLine != null) {
                    String probeName;
                    String[] fields = ParseUtils.string2strings(currLine, "\t");
                    String string = probeName = fields.length <= ps_index ? null : StringUtils.trimToNull((String)fields[ps_index]);
                    if (probeName != null && !names.contains(probeName)) {
                        String symbol;
                        String string2 = symbol = fields.length <= symbol_index ? "" : StringUtils.trimToEmpty((String)fields[symbol_index]);
                        if ("---".equals(symbol)) {
                            symbol = "";
                        }
                        String title = title_index < 0 || fields.length <= title_index ? "" : StringUtils.trimToEmpty((String)fields[title_index]);
                        Probe probe = new Probe(probeName, symbol, title);
                        probesList.add(probe);
                        names.add(probeName);
                    } else if (probeName != null && this.log.isDebugEnabled()) {
                        duplicates.add(probeName);
                    }
                    currLine = this.nextLine(bin);
                }
                Probe[] probes = probesList.toArray(new Probe[probesList.size()]);
                String chipName = FilenameUtils.getName((String)sourcepath);
                Chip chip = new Chip(chipName, sourcepath, probes, msigDBVersion);
                this.log.info("Parsed from dotchip : {}", (Object)probes.length);
                if (!duplicates.isEmpty()) {
                    this.log.debug("There were duplicate probes: {}\n{}\n{}", new Object[]{duplicates.size(), duplicates, chipName});
                }
                list = ChipParser.unmodlist(chip);
            }
            return list;
        }
        finally {
            this.doneImport();
        }
    }
}

