/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.chip;

import edu.mit.broad.vdb.meg.Gene;

public class Probe
implements Gene {
    private String fProbeName;
    private String fSymbol;
    private String fTitle;

    public Probe(String probeId, String symbol, String title) {
        if (probeId == null || symbol == null || title == null) {
            throw new IllegalArgumentException("Parameters cannot be null; use empty string instead.");
        }
        this.fProbeName = probeId;
        this.fSymbol = symbol;
        this.fTitle = title;
    }

    public String toString() {
        return this.fProbeName;
    }

    public int hashCode() {
        return this.fProbeName.hashCode();
    }

    public String getName() {
        return this.fProbeName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Probe) {
            String id = ((Probe)obj).getName();
            return id.equals(this.fProbeName);
        }
        if (obj instanceof Gene) {
            String id = ((Gene)obj).getSymbol();
            return id.equals(this.getSymbol());
        }
        return false;
    }

    public Gene getGene() {
        return this;
    }

    @Override
    public String getSymbol() {
        return this.fSymbol;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public String getTitle_truncated() {
        return Gene.Helper.getTitle_truncated(this.fTitle);
    }
}

