/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import org.genepattern.heatmap.image.HeatMap;
import org.genepattern.heatmap.image.SampleAnnotator;

public class HeatMapHeader {
    HeatMap heatMap;
    boolean drawSampleNames = true;
    Font font;
    int height = 0;
    private int sampleNameHeight;
    private final int spacer = 10;
    private int leftInsets = 0;

    public HeatMapHeader(HeatMap heatMap) {
        this.heatMap = heatMap;
    }

    public void updateSize(int contentWidth, int elementWidth, Graphics2D g) {
        this.setElementWidth(elementWidth);
        if (this.heatMap.antiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics hfm = g.getFontMetrics();
        int maxHeight = 0;
        this.sampleNameHeight = 0;
        if (this.drawSampleNames) {
            for (int j = 0; j < this.heatMap.data.getColumnCount(); ++j) {
                String name = this.heatMap.data.getColumnName(j);
                this.sampleNameHeight = Math.max(this.sampleNameHeight, hfm.stringWidth(name));
            }
        }
        maxHeight += this.sampleNameHeight;
        if (this.heatMap.sampleAnnotator != null) {
            maxHeight += this.getAnnotationsHeight();
        }
        if (this.drawSampleNames) {
            maxHeight += 10;
        }
        this.height = maxHeight;
    }

    void draw(Graphics2D g2) {
        if (this.heatMap.antiAliasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawHeader(g2);
    }

    private void drawHeader(Graphics2D g2) {
        int j;
        SampleAnnotator annotator;
        int samples = this.heatMap.data.getColumnCount();
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(Color.black);
        int sampleNamePix = -this.height;
        int colorBarHeight = this.getAnnotationsHeight();
        if (colorBarHeight > 0) {
            sampleNamePix += colorBarHeight;
        }
        if ((annotator = this.heatMap.sampleAnnotator) != null && annotator.hasPhenotypeColors()) {
            for (j = 0; j < samples; ++j) {
                Color c = annotator.getPhenotypeColor(this.heatMap.data.getColumnName(j));
                if (c == null) continue;
                g2.setColor(c);
                int bottom = this.height - colorBarHeight;
                int top = bottom - this.sampleNameHeight - fm.getMaxAdvance();
                g2.fillRect(j * this.heatMap.elementSize.width + this.leftInsets, top, this.heatMap.elementSize.width, this.sampleNameHeight + fm.getMaxAdvance());
            }
        }
        if (this.drawSampleNames) {
            g2.setColor(Color.BLACK);
            g2.rotate(-1.5707963267948966);
            for (int sample = 0; sample < samples; ++sample) {
                String name = this.heatMap.data.getColumnName(sample);
                g2.drawString(name, sampleNamePix, fm.getAscent() + this.heatMap.elementSize.width * sample + this.leftInsets);
            }
            g2.rotate(1.5707963267948966);
        }
        if (this.heatMap.numSampleClasses > 0) {
            for (j = 0; j < samples; ++j) {
                List colors = annotator.getColors(this.heatMap.data.getColumnName(j));
                if (colors == null) continue;
                for (int i = 0; i < colors.size(); ++i) {
                    Color c = (Color)colors.get(i);
                    if (c == null) continue;
                    g2.setColor(c);
                    int y = this.height - (i + 1) * this.heatMap.ds.sampleAnnonationsHeight - i * this.heatMap.ds.sampleAnnotationSpacing - 10;
                    g2.fillRect(j * this.heatMap.elementSize.width + this.leftInsets, y, this.heatMap.elementSize.width, this.heatMap.ds.sampleAnnonationsHeight);
                }
            }
            Font oldFont = g2.getFont();
            g2.setColor(Color.BLACK);
            g2.setFont(new Font(this.heatMap.fontFamilyName, this.heatMap.fontStyle, this.heatMap.ds.sampleAnnonationsHeight));
            for (int i = 0; i < this.heatMap.numSampleClasses; ++i) {
                String label = annotator.getLabel(i);
                if (label == null) continue;
                int y = this.height - (i + 1) * this.heatMap.ds.sampleAnnonationsHeight - i * this.heatMap.ds.sampleAnnotationSpacing - 10;
                g2.drawString(label, samples * this.heatMap.elementSize.width + this.leftInsets + 10, y + fm.getAscent());
            }
            g2.setFont(oldFont);
        }
    }

    private void setElementWidth(int width) {
        width = Math.min(width, 14);
        this.font = new Font(this.heatMap.fontFamilyName, this.heatMap.fontStyle, width);
    }

    private int getAnnotationsHeight() {
        return this.heatMap.numSampleClasses > 0 ? this.heatMap.ds.sampleAnnonationsHeight * this.heatMap.numSampleClasses + this.heatMap.numSampleClasses * this.heatMap.ds.sampleAnnotationSpacing + 10 : 10;
    }
}

