/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.menu.jfree.JFreeMenuBar;
import org.genepattern.uiutil.CenteredDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ProfilePlot {
    private IExpressionData expressionData;
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private JDialog dialog;

    private static final void createLegend(JFreeChart jfree) {
        Plot plot = jfree.getPlot();
        LegendTitle legend = new LegendTitle((LegendItemSource)plot);
        legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        Rectangle2D bounds = legend.getBounds();
        legend.setBorder(1.0, 1.0, 1.0, 1.0);
        legend.setBackgroundPaint((Paint)Color.white);
        legend.setPosition(RectangleEdge.BOTTOM);
        jfree.clearSubtitles();
        jfree.addSubtitle((Title)legend);
    }

    public ProfilePlot(Frame parent, IExpressionData expressionData) {
        this.expressionData = expressionData;
        this.chart = ChartFactory.createScatterPlot((String)"", (String)"Column", (String)"Value", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart, false, false, false, false, false);
        this.chartPanel.setMouseZoomable(true, false);
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
        lineRenderer.setDefaultLinesVisible(true);
        String[] columnNames = new String[expressionData.getColumnCount()];
        int columns = expressionData.getColumnCount();
        for (int j = 0; j < columns; ++j) {
            columnNames[j] = expressionData.getColumnName(j);
        }
        SymbolAxis xAxis = new SymbolAxis("Column", columnNames);
        xAxis.setVerticalTickLabels(true);
        this.chart.getXYPlot().setDomainAxis((ValueAxis)xAxis);
        if (parent != null) {
            this.dialog = new CenteredDialog(parent);
            this.dialog.setTitle("Profile");
            this.dialog.getContentPane().add((Component)this.chartPanel);
            this.dialog.setJMenuBar(new JFreeMenuBar((JComponent)this.chartPanel, parent));
        }
    }

    public void plot(int[] rowIndices) {
        XYSeriesCollection coll = new XYSeriesCollection();
        int rows = rowIndices != null ? rowIndices.length : this.expressionData.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int index = rowIndices != null ? rowIndices[i] : i;
            XYSeries series = new XYSeries((Comparable)((Object)this.expressionData.getRowName(index)));
            for (int j = 0; j < this.expressionData.getColumnCount(); ++j) {
                series.add((double)j, this.expressionData.getValue(index, j));
            }
            coll.addSeries(series);
        }
        this.chart.getXYPlot().setDataset((XYDataset)coll);
        if (rowIndices != null && rowIndices.length <= 5) {
            ProfilePlot.createLegend(this.chart);
        } else {
            this.chart.clearSubtitles();
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                ProfilePlot.this.dialog.pack();
                ProfilePlot.this.dialog.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            t.run();
        } else {
            SwingUtilities.invokeLater(t);
        }
    }
}

