/*
 * Decompiled with CFR 0.152.
 */
package xtools.api;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.utils.ClassUtils;
import edu.mit.broad.genome.utils.CmdLineArgs;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.genome.utils.Timer;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.core.api.Application;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.P;
import org.apache.ecs.html.UL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.UpdateChecker;
import xtools.api.Tool;
import xtools.api.XToolsApplication;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.GuiParam;
import xtools.api.param.Param;
import xtools.api.param.ParamSet;
import xtools.api.param.ReportDirParam;
import xtools.api.param.ReportLabelParam;
import xtools.api.param.ToolParamSet;

public abstract class AbstractTool
implements Tool {
    public static final String REPORT_INDEX = "xtools.report_index";
    private PrintStream fOut;
    protected transient Logger log;
    protected ToolParamSet fParamSet;
    private Timer fTimer;
    private boolean fHelpMode;
    protected static final Object[] EMPTY_OBJECTS;
    protected final BooleanParam fHelpParam = new BooleanParam("help", "Usage information on the tool", false);
    private ReportDirParam fReportDirParam;
    private GuiParam fGuiParam;
    private ReportLabelParam fRptLabelParam;
    protected ToolReport fReport;
    private static int SHARED_PARAM_CNT;

    protected AbstractTool() {
        this("dummy");
    }

    @Override
    public String getHelpURL() {
        return JarResources.getHelpURL(this.getClass().getName());
    }

    public PrintStream getOutputStream() {
        if (this.fOut == null) {
            this.fOut = System.out;
        }
        return this.fOut;
    }

    protected AbstractTool(String toolName) {
        this.fTimer = new Timer();
        this.log = LoggerFactory.getLogger(this.getClass());
        if (!Application.isHandlerSet()) {
            Application.registerHandler(new XToolsApplication());
        }
        this.fParamSet = new ToolParamSet();
        this.fGuiParam = new GuiParam();
        this.fRptLabelParam = new ReportLabelParam(false);
        this.fReportDirParam = new ReportDirParam(false);
        this.fParamSet.addParam(this.fGuiParam);
        this.fParamSet.addParam(this.fReportDirParam);
        this.fParamSet.addParam(this.fRptLabelParam);
    }

    protected void init(Properties prp, String paramFilePath) {
        this.fParamSet.addParam(this.fHelpParam);
        this.declareParams();
        if (prp != null && (prp.containsKey("help") || prp.containsKey("HELP"))) {
            this.fHelpMode = true;
        }
        if (this.isHelpMode()) {
            this.fParamSet.printfUsage();
            Conf.exitSystem(false);
        } else {
            try {
                if (StringUtils.isNotBlank((CharSequence)paramFilePath)) {
                    this.enhanceParams(paramFilePath, prp);
                }
                this.fParamSet.fill(prp);
                this.fParamSet.check();
                this.ensureAllDeclaredWereAdded();
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (this.fReport != null) {
                    this.fReport.setErroredOut();
                }
                this.log.info("No report dir was made yet (analysis errored out)");
            }
        }
    }

    protected void init(String[] args) {
        Properties prp = CmdLineArgs.parse(args);
        String argline = CmdLineArgs.toString(args);
        int index = argline.indexOf("help");
        if (index != -1) {
            prp.setProperty("help", Boolean.TRUE.toString());
        }
        String param_file_path = prp.getProperty("param_file");
        this.init(prp, param_file_path);
    }

    private void enhanceParams(String filepath, Properties prp) throws Exception {
        Properties addPrp = ParseUtils.readKeyVal(filepath);
        for (String param_name : addPrp.stringPropertyNames()) {
            String param_val = addPrp.getProperty(param_name);
            if (prp.containsKey(param_name)) {
                String extant_param_val = prp.getProperty(param_name);
                if (param_val.equals(extant_param_val)) continue;
                this.log.warn("Ignoring param_file key: {} value: {} in favor of cmd line value: {}", new Object[]{param_name, param_val, extant_param_val});
                continue;
            }
            prp.setProperty(param_name, param_val);
        }
    }

    protected void startExec() throws IOException {
        this.startExec(this.getHeader());
    }

    protected String getHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">Report for: ").append(this.getClass().getName()).append("</font></h3>\n").append("</div>");
        return buf.toString();
    }

    protected void startExec(String optHeader) throws IOException {
        this.startExec(this.makeReportIndexPage(), optHeader);
    }

    protected void startExec(ReportIndexState indexState) throws IOException {
        UpdateChecker.oneTimeGseaUpdateCheck(null);
        this.fTimer.start();
        this.fReport = new ToolReport(this, true, indexState);
    }

    protected void startExec(boolean makeReportIndexPage, String headerOpt) throws IOException {
        this.startExec(new ReportIndexState(makeReportIndexPage, headerOpt));
    }

    private boolean makeReportIndexPage() {
        String p = System.getProperty(REPORT_INDEX);
        if (p == null || p.length() == 0) {
            return true;
        }
        return Boolean.valueOf(p);
    }

    public void doneExec() {
        H4 h4;
        Div div;
        if (!this.fReport.getToolComments().isEmpty() && this.fReport.getIndexPage() != null) {
            div = new Div();
            h4 = new H4("Comments");
            div.addElement((Element)h4);
            div.addElement((Element)this.fReport.getToolComments().toHTML());
            this.fReport.getIndexPage().addBlock(div, false);
        }
        if (!this.fReport.getToolWarnings().isEmpty() && this.fReport.getIndexPage() != null) {
            div = new Div();
            h4 = new H4("Warnings");
            h4.addAttribute("style", "color: magenta;");
            div.addElement((Element)h4);
            div.addElement((Element)this.fReport.getToolWarnings().toHTML());
            this.fReport.getIndexPage().addBlock(div, false);
        }
        if (this.fReport.getIndexPage() != null) {
            div = new Div();
            h4 = new H4("Citing GSEA and MSigDB");
            div.addElement((Element)h4);
            P citingGsea = new P();
            StringElement citingGseaText = new StringElement("To cite your use of the GSEA software please reference the following:");
            LI citingGsea2005 = new LI((Element)HtmlFormat.Links.hyper("Subramanian, A., Tamayo, P., et al. (2005, PNAS). ", "https://www.pnas.org/content/102/43/15545", null));
            LI citingGsea2003 = new LI((Element)HtmlFormat.Links.hyper("Mootha, V. K., Lindgren, C. M., et al. (2003, Nature Genetics). ", "http://www.nature.com/ng/journal/v34/n3/abs/ng1180.html", null));
            citingGsea.addElement((Element)citingGseaText).addElement((Element)new UL().addElement((Element)citingGsea2005).addElement((Element)citingGsea2003));
            div.addElement((Element)citingGsea);
            P citingMSigDB = new P();
            StringElement citingMSigDBText = new StringElement("For use of the Molecular Signatures Database (MSigDB), to cite please reference <br/ >one or more of the following as appropriate, along with the source for the gene set as listed on the gene set page: ");
            LI citingMSigDB2011 = new LI((Element)HtmlFormat.Links.hyper("Liberzon A, et al. (Bioinformatics, 2011). ", "https://doi.org/10.1093/bioinformatics/btr260", null));
            LI citingMSigDB2015 = new LI((Element)HtmlFormat.Links.hyper("Liberzon A, et al. (Cell Systems 2015). ", "https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4707969/", null));
            citingMSigDB.addElement((Element)citingMSigDBText).addElement((Element)new UL().addElement((Element)citingMSigDB2011).addElement((Element)citingMSigDB2015));
            div.addElement((Element)citingMSigDB);
            this.fReport.getIndexPage().addBlock(div, false);
        }
        this.fReport.closeReport(true);
        if (this.fGuiParam.isTrue()) {
            this.fReport.display();
        }
        this.fTimer.stop();
        this.fTimer.printTimeTakenS();
    }

    @Override
    public Report getReport() {
        return this.fReport;
    }

    private int countParamFields(Class cl) {
        Field[] fields = cl.getDeclaredFields();
        int paramcnt = 0;
        for (int i = 0; i < fields.length; ++i) {
            Class<?> fc = fields[i].getType();
            boolean isParam = Param.class.isAssignableFrom(fc);
            if (!isParam) continue;
            ++paramcnt;
        }
        return paramcnt;
    }

    protected void ensureAllDeclaredWereAdded() {
        int paramCnt = SHARED_PARAM_CNT;
        paramCnt += this.countParamFields(this.getClass());
        if (!this.getClass().getSuperclass().getName().equals("xtools.api.AbstractTool")) {
            paramCnt += this.countParamFields(this.getClass().getSuperclass());
        }
        if (!this.getClass().getSuperclass().getSuperclass().getName().equals("xtools.api.AbstractTool")) {
            paramCnt += this.countParamFields(this.getClass().getSuperclass().getSuperclass());
        }
        if (this.fParamSet.getNumParams() != paramCnt) {
            StringBuilder buf = new StringBuilder("Have you forgotten to update declareParams()?").append('\n');
            buf.append("In ParamSet # declared: ").append(this.fParamSet.getNumParams()).append(" is NOT equal to deduced thro reflection # : ").append(paramCnt);
            throw new IllegalStateException(buf.toString());
        }
    }

    public boolean isHelpMode() {
        return this.fHelpMode;
    }

    @Override
    public ParamSet getParamSet() {
        this.fParamSet.sort();
        return this.fParamSet;
    }

    @Override
    public String getTitle() {
        String sn = ClassUtils.shorten(this.getClass().getName());
        String desc = this.getDesc();
        if (desc == null || desc.length() == 0) {
            return "<html><body><b>" + sn + "</b></body></html>";
        }
        return "<html><body><b>" + sn + "</b>: " + desc + "</body></html>";
    }

    @Override
    public String getDesc() {
        return "";
    }

    public static BooleanParam createZipReportParam(boolean reqd) {
        return new BooleanParam("zip_report", "Make a zipped file with all reports", "Create a zipped file with all files made by the report. This can be emailed to share results", false, reqd, Param.ADVANCED);
    }

    protected static void tool_main(AbstractTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        boolean was_error = false;
        try {
            tool.execute();
        }
        catch (Throwable t) {
            was_error = true;
            t.printStackTrace();
        }
        if (was_error && tool.getReport() != null) {
            tool.getReport().setErroredOut();
        }
        if (tool.getParamSet().getGuiParam().isFalse()) {
            Conf.exitSystem(was_error);
        }
    }

    public static boolean module_main(AbstractTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        try {
            tool.execute();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (tool.getReport() != null) {
                tool.getReport().setErroredOut();
            }
            return false;
        }
    }

    public static void setChip(Dataset ds, ChipOptParam chipOptParam) throws Exception {
        if (chipOptParam != null && chipOptParam.isSpecified()) {
            AbstractTool.setChip(ds, chipOptParam.getChip());
        }
    }

    private static void setChip(Dataset ds, Chip chip) throws Exception {
        if (chip != null) {
            ds.getAnnot().setChip(chip);
        }
    }

    static {
        if (!SystemUtils.isPropertyDefined("java.awt.headless")) {
            System.setProperty("java.awt.headless", "true");
        }
        EMPTY_OBJECTS = new Object[0];
        SHARED_PARAM_CNT = 4;
    }
}

