/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class LegacyTristateCheckBox
extends JCheckBox {
    public static final String PROPERTY_STATE = "state";
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State DONT_CARE = new State();
    private final TristateDecorator model;

    public LegacyTristateCheckBox(String string, Icon icon, State state) {
        super(string, icon);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LegacyTristateCheckBox.this.grabFocus();
                LegacyTristateCheckBox.this.setState(LegacyTristateCheckBox.this.getNextState(LegacyTristateCheckBox.this.getState()));
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 7121802319351334948L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LegacyTristateCheckBox.this.grabFocus();
                LegacyTristateCheckBox.this.setState(LegacyTristateCheckBox.this.getNextState(LegacyTristateCheckBox.this.getState()));
            }
        });
        actionMapUIResource.put("released", null);
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(state);
    }

    public LegacyTristateCheckBox(String string, State state) {
        this(string, null, state);
    }

    public LegacyTristateCheckBox(String string) {
        this(string, DONT_CARE);
    }

    public LegacyTristateCheckBox() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
    }

    public void setState(State state) {
        State state2 = this.model.getState();
        this.model.setState(state);
        if (state2 != state) {
            this.firePropertyChange(PROPERTY_STATE, state2, state);
        }
        if (LookAndFeelFactory.isSyntheticaLnfInstalled() && (UIManager.getLookAndFeel().getClass().getName().startsWith("de.javasoft.plaf.synthetica.Synthetica") || LookAndFeelFactory.isLnfInUse("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel"))) {
            if (state == DONT_CARE) {
                this.setName("HalfSelected");
            } else {
                this.setName("");
            }
        }
    }

    public State getState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    protected State getNextState(State state) {
        if (state == NOT_SELECTED) {
            return SELECTED;
        }
        if (state == SELECTED) {
            return DONT_CARE;
        }
        return NOT_SELECTED;
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;
        private State _state;

        private TristateDecorator(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
            this._state = state;
        }

        private State getState() {
            return this._state == null ? DONT_CARE : this._state;
        }

        @Override
        public void setArmed(boolean bl) {
        }

        @Override
        public void setEnabled(boolean bl) {
            LegacyTristateCheckBox.this.setFocusable(bl);
            this.other.setEnabled(bl);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean bl) {
            this.other.setSelected(bl);
        }

        @Override
        public void setPressed(boolean bl) {
            this.other.setPressed(bl);
        }

        @Override
        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        @Override
        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static class State {
        private State() {
        }
    }
}

