/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.utils.ImmutedException;
import gnu.trove.TFloatArrayList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.floatmatrix.DenseFloatMatrix2D;
import org.ujmp.core.floatmatrix.impl.DefaultDenseFloatMatrix2D;

public class Matrix
extends AbstractObject {
    private static int name_cnt;
    private DenseFloatMatrix2D ourMatrix;
    private int fRowCnt;
    private int fColCnt;
    private boolean fImmuted;
    private Vector fColMaxes;
    private Vector fColMins;

    public Matrix(int nrows, int ncols) {
        super.initialize("matrix_" + name_cnt++);
        if (nrows < 0) {
            throw new NegativeArraySizeException(nrows + " < 0");
        }
        if (ncols < 0) {
            throw new NegativeArraySizeException(ncols + " < 0");
        }
        this.fRowCnt = nrows;
        this.fColCnt = ncols;
        this.ourMatrix = (DenseFloatMatrix2D)org.ujmp.core.Matrix.Factory.zeros(ValueType.FLOAT, new long[]{nrows, ncols});
    }

    @Override
    public String getQuickInfo() {
        return this.getNumRow() + " x " + this.getNumCol();
    }

    public Matrix(int nrows, int ncols, TFloatArrayList floats) {
        if (nrows < 0) {
            throw new NegativeArraySizeException(nrows + " < 0");
        }
        if (ncols < 0) {
            throw new NegativeArraySizeException(ncols + " < 0");
        }
        this.fRowCnt = nrows;
        this.fColCnt = ncols;
        float[] elementData = floats.toNativeArray();
        this.ourMatrix = (DenseFloatMatrix2D)org.ujmp.core.Matrix.Factory.zeros(ValueType.FLOAT, new long[]{nrows, ncols});
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < ncols; ++col) {
                this.ourMatrix.setFloat(elementData[row * this.fColCnt + col], row, col);
            }
        }
    }

    public Matrix(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("Param matrix cannot be null");
        }
        this.fRowCnt = matrix.fRowCnt;
        this.fColCnt = matrix.fColCnt;
        this.fImmuted = false;
        this.ourMatrix = (DefaultDenseFloatMatrix2D)org.ujmp.core.Matrix.Factory.copyFromMatrix((org.ujmp.core.Matrix)matrix.ourMatrix);
    }

    public Matrix cloneDeep() {
        return new Matrix(this);
    }

    public int getNumRow() {
        return this.fRowCnt;
    }

    public int getNumCol() {
        return this.fColCnt;
    }

    public int getDim() {
        return this.getNumRow() * this.getNumCol();
    }

    public float getElement(int row, int column) {
        if (this.fRowCnt <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (this.fColCnt <= column) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " < 0");
        }
        return this.ourMatrix.getFloat(row, column);
    }

    public void setElement(int row, int column, float value) {
        this.checkImmutable();
        if (this.fRowCnt <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (this.fColCnt <= column) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " < 0");
        }
        this.ourMatrix.setFloat(value, row, column);
    }

    public Vector getRowV(int row) {
        if (this.fRowCnt <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        float[] rowContents = new float[this.fColCnt];
        for (int i = 0; i < this.fColCnt; ++i) {
            rowContents[i] = this.ourMatrix.getFloat(row, i);
        }
        return new Vector(rowContents, false);
    }

    public Vector getColumnV(int col) {
        if (this.fColCnt <= col) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " > matrix's fColCnt:" + this.fColCnt);
        }
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " < 0");
        }
        float[] colContents = new float[this.fRowCnt];
        for (int i = 0; i < this.fRowCnt; ++i) {
            colContents[i] = this.ourMatrix.getFloat(i, col);
        }
        return new Vector(colContents, false);
    }

    public Vector getColumnMaxes() {
        if (this.fColMaxes == null) {
            org.ujmp.core.Matrix colMaxes = this.ourMatrix.max(Calculation.Ret.NEW, 0);
            this.fColMaxes = new Vector(this.getNumCol());
            for (int c = 0; c < this.getNumCol(); ++c) {
                this.fColMaxes.setElement(c, colMaxes.getAsFloat(new long[]{0L, c}));
            }
        }
        return this.fColMaxes;
    }

    public Vector getColumnMins() {
        if (this.fColMins == null) {
            org.ujmp.core.Matrix colMins = this.ourMatrix.min(Calculation.Ret.NEW, 0);
            this.fColMins = new Vector(this.getNumCol());
            for (int c = 0; c < this.getNumCol(); ++c) {
                this.fColMins.setElement(c, colMins.getAsFloat(new long[]{0L, c}));
            }
        }
        return this.fColMins;
    }

    public void setRow(int row, float[] array) {
        this.checkImmutable();
        if (this.fRowCnt <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (array.length < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("array length:" + array.length + " < matrix's fColCnt=" + this.fColCnt);
        }
        for (int i = 0; i < this.fColCnt; ++i) {
            this.ourMatrix.setFloat(array[i], row, i);
        }
    }

    public void setRow(int row, Vector vector) {
        this.checkImmutable();
        if (this.fRowCnt <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's fRowCnt:" + this.fRowCnt);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        int vecSize = vector.getSize();
        if (vecSize < this.fColCnt) {
            throw new ArrayIndexOutOfBoundsException("vector's size:" + vecSize + " < matrix's fColCnt=" + this.fColCnt);
        }
        for (int i = 0; i < this.fColCnt; ++i) {
            this.ourMatrix.setFloat(vector.getElement(i), row, i);
        }
    }

    public void setColumn(int col, Vector vector) {
        this.checkImmutable();
        if (this.fColCnt <= col) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " > matrix's fColCnt=" + this.fColCnt);
        }
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " < 0");
        }
        int vecSize = vector.getSize();
        if (vecSize < this.fRowCnt) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + vecSize + " < matrix's fRowCnt=" + this.fRowCnt);
        }
        for (int i = 0; i < vector.getSize(); ++i) {
            this.ourMatrix.setFloat(vector.getElement(i), i, col);
        }
    }

    public String toString() {
        return this.ourMatrix.toString();
    }

    public int hashCode() {
        return this.ourMatrix.hashCode();
    }

    public boolean equals(Object o1) {
        return this.ourMatrix.equals(o1);
    }

    public void divide(Matrix m1, boolean setDivByZeroAsZero) {
        this.checkImmutable();
        Matrix._enforceEqualDimensions(this, m1);
        for (int i = 0; i < this.fRowCnt; ++i) {
            for (int j = 0; j < this.fColCnt; ++j) {
                float f1 = m1.ourMatrix.getFloat(i, j);
                if (setDivByZeroAsZero && f1 == 0.0f) {
                    this.ourMatrix.setFloat(0.0f, i, j);
                    continue;
                }
                float f2 = this.getElement(i, j);
                this.ourMatrix.setFloat(f2 / f1, i, j);
            }
        }
    }

    public void setImmutable() {
        this.fImmuted = true;
    }

    private void checkImmutable() {
        if (this.fImmuted) {
            throw new ImmutedException();
        }
    }

    public static void save(Matrix m, File toFile) throws Exception {
        PrintWriter pw = new PrintWriter(new FileOutputStream(toFile));
        for (int r = 0; r < m.getNumRow(); ++r) {
            pw.println(m.getRowV(r).toString('\t'));
        }
        pw.close();
    }

    private static void _enforceEqualDimensions(Matrix a, Matrix b) {
        if (a.getNumRow() != b.getNumRow()) {
            throw new IllegalArgumentException("Mismatched matrices: must be of equal row lengths a: " + a.getNumRow() + " b: " + b.getNumRow());
        }
        if (a.getNumCol() != b.getNumCol()) {
            throw new IllegalArgumentException("Mismatched matrices: must be of equal col lengths a: " + a.getNumCol() + " b: " + b.getNumCol());
        }
    }
}

