/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.net.ServerSocket;
import java.net.Socket;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.io.MatrixCommunicationThread;

public class MatrixSocketThread
extends Thread {
    private final Matrix matrix;
    private final ServerSocket serverSocket;

    public MatrixSocketThread(Matrix matrix, ServerSocket serverSocket) {
        this.matrix = matrix;
        this.serverSocket = serverSocket;
        this.setName("Matrix Socket on Port " + serverSocket.getLocalPort());
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        while (!this.serverSocket.isClosed()) {
            try {
                System.out.println("UJMP ServerMatrix is waiting for connections on port " + this.serverSocket.getLocalPort());
                Socket socket = this.serverSocket.accept();
                new MatrixCommunicationThread(this.matrix, socket);
                System.out.println("UJMP ClientMatrix connected on port " + this.serverSocket.getLocalPort());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

