/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.util.Complex;

public class MandelbrotMatrix
extends AbstractDenseDoubleMatrix2D {
    private static final long serialVersionUID = -1420083425681944756L;
    private final double xoffset;
    private final double yoffset;
    private final double xsize;
    private final double ysize;
    private final int iterations;

    public MandelbrotMatrix() {
        this(500, 500);
    }

    public MandelbrotMatrix(int rows, int columns) {
        this(rows, columns, 32);
    }

    public MandelbrotMatrix(int rows, int columns, int iterations) {
        this(rows, columns, iterations, -0.5, 0.0, 2.0, 2.0);
    }

    public MandelbrotMatrix(int rows, int columns, int iterations, double xoffset, double yoffset, double xsize, double ysize) {
        super((long)rows, (long)columns);
        this.iterations = iterations;
        this.xoffset = xoffset;
        this.yoffset = yoffset;
        this.xsize = xsize;
        this.ysize = ysize;
    }

    public double getDouble(long row, long column) {
        double x0 = this.xoffset - this.xsize / 2.0 + this.xsize * (double)column / (double)this.size[1];
        double y0 = this.yoffset - this.ysize / 2.0 + this.ysize * (double)row / (double)this.size[0];
        Complex z0 = new Complex(x0, y0);
        double gray = this.iterations - MandelbrotMatrix.calc(z0, this.iterations);
        return (gray - (double)this.iterations / 2.0) / ((double)this.iterations / 2.0);
    }

    public void setDouble(double value, long row, long column) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int row, int column) {
        return this.getDouble((long)row, (long)column);
    }

    public void setDouble(double value, int row, int column) {
        throw new UnsupportedOperationException();
    }

    public static final int calc(Complex c, int iterations) {
        Complex z = c;
        for (int i = 0; i < iterations; ++i) {
            if (z.abs() > 2.0) {
                return i;
            }
            z = z.times(z).plus(c);
        }
        return iterations;
    }
}

