/*  $Id: ecnum_ambiguous.inc 663265 2023-02-15 18:43:14Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  The Enzyme Commission
 *
 * File Description:
 *   Built-in copy of ecnum_ambiguous.txt.
 *
 */

/* time_t value corresponding to Tue Feb 14 13:22:03 EST 2023
; formally
 * expressed as unsigned long so output can stand fully on its own. */
static const unsigned long kECNum_ambiguous_Timestamp = 1676398923UL;
static const char* const kECNum_ambiguous[] = {
    "1.-.-.-\tOxidoreductases",
    "1.n.n.n\tOxidoreductases",
    "1.1.-.-\tActing on the CH-OH group of donors",
    "1.1.n.n\tActing on the CH-OH group of donors",
    "1.1.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.1.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.1.2.-\tWith a cytochrome as acceptor",
    "1.1.2.n\tWith a cytochrome as acceptor",
    "1.1.3.-\tWith oxygen as acceptor",
    "1.1.3.n\tWith oxygen as acceptor",
    "1.1.4.-\tWith a disulfide as acceptor",
    "1.1.4.n\tWith a disulfide as acceptor",
    "1.1.5.-\tWith a quinone or similar compound as acceptor",
    "1.1.5.n\tWith a quinone or similar compound as acceptor",
    "1.1.7.-\tWith an iron-sulfur protein as acceptor",
    "1.1.7.n\tWith an iron-sulfur protein as acceptor",
    "1.1.9.-\tWith a copper protein as acceptor",
    "1.1.9.n\tWith a copper protein as acceptor",
    "1.1.98.-\tWith other, known, acceptors",
    "1.1.98.n\tWith other, known, acceptors",
    "1.1.99.-\tWith other acceptors",
    "1.1.99.n\tWith other acceptors",
    "1.2.-.-\tActing on the aldehyde or oxo group of donors",
    "1.2.n.n\tActing on the aldehyde or oxo group of donors",
    "1.2.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.2.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.2.2.-\tWith a cytochrome as acceptor",
    "1.2.2.n\tWith a cytochrome as acceptor",
    "1.2.3.-\tWith oxygen as acceptor",
    "1.2.3.n\tWith oxygen as acceptor",
    "1.2.4.-\tWith a disulfide as acceptor",
    "1.2.4.n\tWith a disulfide as acceptor",
    "1.2.5.-\tWith a quinone or similar compound as acceptor",
    "1.2.5.n\tWith a quinone or similar compound as acceptor",
    "1.2.7.-\tWith an iron-sulfur protein as acceptor",
    "1.2.7.n\tWith an iron-sulfur protein as acceptor",
    "1.2.98.-\tWith other, known, acceptors",
    "1.2.98.n\tWith other, known, acceptors",
    "1.2.99.-\tWith other acceptors",
    "1.2.99.n\tWith other acceptors",
    "1.3.-.-\tActing on the CH-CH group of donors",
    "1.3.n.n\tActing on the CH-CH group of donors",
    "1.3.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.3.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.3.2.-\tWith a cytochrome as acceptor",
    "1.3.2.n\tWith a cytochrome as acceptor",
    "1.3.3.-\tWith oxygen as acceptor",
    "1.3.3.n\tWith oxygen as acceptor",
    "1.3.4.-\tWith a disulfide as acceptor",
    "1.3.4.n\tWith a disulfide as acceptor",
    "1.3.5.-\tWith a quinone or related compound as acceptor",
    "1.3.5.n\tWith a quinone or related compound as acceptor",
    "1.3.7.-\tWith an iron-sulfur protein as acceptor",
    "1.3.7.n\tWith an iron-sulfur protein as acceptor",
    "1.3.8.-\tWith a flavin as acceptor",
    "1.3.8.n\tWith a flavin as acceptor",
    "1.3.98.-\tWith other, known, acceptors",
    "1.3.98.n\tWith other, known, acceptors",
    "1.3.99.-\tWith other acceptors",
    "1.3.99.n\tWith other acceptors",
    "1.4.-.-\tActing on the CH-NH2 group of donors",
    "1.4.n.n\tActing on the CH-NH2 group of donors",
    "1.4.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.4.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.4.2.-\tWith a cytochrome as acceptor",
    "1.4.2.n\tWith a cytochrome as acceptor",
    "1.4.3.-\tWith oxygen as acceptor",
    "1.4.3.n\tWith oxygen as acceptor",
    "1.4.4.-\tWith a disulfide as acceptor",
    "1.4.4.n\tWith a disulfide as acceptor",
    "1.4.5.-\tWith a quinone or similar compound as acceptor",
    "1.4.5.n\tWith a quinone or similar compound as acceptor",
    "1.4.7.-\tWith an iron-sulfur protein as acceptor",
    "1.4.7.n\tWith an iron-sulfur protein as acceptor",
    "1.4.9.-\tWith a copper protein as acceptor",
    "1.4.9.n\tWith a copper protein as acceptor",
    "1.4.98.-\tWith other, known, acceptors",
    "1.4.98.n\tWith other, known, acceptors",
    "1.4.99.-\tWith other acceptors",
    "1.4.99.n\tWith other acceptors",
    "1.5.-.-\tActing on the CH-NH group of donors",
    "1.5.n.n\tActing on the CH-NH group of donors",
    "1.5.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.5.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.5.3.-\tWith oxygen as acceptor",
    "1.5.3.n\tWith oxygen as acceptor",
    "1.5.4.-\tWith a disulfide as acceptor",
    "1.5.4.n\tWith a disulfide as acceptor",
    "1.5.5.-\tWith a quinone or similar compound as acceptor",
    "1.5.5.n\tWith a quinone or similar compound as acceptor",
    "1.5.7.-\tWith an iron-sulfur protein as acceptor",
    "1.5.7.n\tWith an iron-sulfur protein as acceptor",
    "1.5.8.-\tWith a flavin as acceptor",
    "1.5.8.n\tWith a flavin as acceptor",
    "1.5.98.-\tWith other, known, acceptors",
    "1.5.98.n\tWith other, known, acceptors",
    "1.5.99.-\tWith other acceptors",
    "1.5.99.n\tWith other acceptors",
    "1.6.-.-\tActing on NADH or NADPH",
    "1.6.n.n\tActing on NADH or NADPH",
    "1.6.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.6.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.6.2.-\tWith a heme protein as acceptor",
    "1.6.2.n\tWith a heme protein as acceptor",
    "1.6.3.-\tWith oxygen as acceptor",
    "1.6.3.n\tWith oxygen as acceptor",
    "1.6.4.-\tWith a disulfide as acceptor",
    "1.6.4.n\tWith a disulfide as acceptor",
    "1.6.5.-\tWith a quinone or similar compound as acceptor",
    "1.6.5.n\tWith a quinone or similar compound as acceptor",
    "1.6.6.-\tWith a nitrogenous group as acceptor",
    "1.6.6.n\tWith a nitrogenous group as acceptor",
    "1.6.7.-\tWith a iron-sulfur protein as acceptor",
    "1.6.7.n\tWith a iron-sulfur protein as acceptor",
    "1.6.8.-\tWith a flavin as acceptor",
    "1.6.8.n\tWith a flavin as acceptor",
    "1.6.99.-\tWith other acceptors",
    "1.6.99.n\tWith other acceptors",
    "1.7.-.-\tActing on other nitrogenous compounds as donors",
    "1.7.n.n\tActing on other nitrogenous compounds as donors",
    "1.7.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.7.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.7.2.-\tWith a cytochrome as acceptor",
    "1.7.2.n\tWith a cytochrome as acceptor",
    "1.7.3.-\tWith oxygen as acceptor",
    "1.7.3.n\tWith oxygen as acceptor",
    "1.7.5.-\tWith a quinone or similar compound as acceptor",
    "1.7.5.n\tWith a quinone or similar compound as acceptor",
    "1.7.6.-\tWith a nitrogenous group as acceptor",
    "1.7.6.n\tWith a nitrogenous group as acceptor",
    "1.7.7.-\tWith an iron-sulfur protein as acceptor",
    "1.7.7.n\tWith an iron-sulfur protein as acceptor",
    "1.7.9.-\tWith a copper protein as acceptor",
    "1.7.9.n\tWith a copper protein as acceptor",
    "1.7.99.-\tWith other acceptors",
    "1.7.99.n\tWith other acceptors",
    "1.8.-.-\tActing on a sulfur group of donors",
    "1.8.n.n\tActing on a sulfur group of donors",
    "1.8.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.8.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.8.2.-\tWith a cytochrome as acceptor",
    "1.8.2.n\tWith a cytochrome as acceptor",
    "1.8.3.-\tWith oxygen as acceptor",
    "1.8.3.n\tWith oxygen as acceptor",
    "1.8.4.-\tWith a disulfide as acceptor",
    "1.8.4.n\tWith a disulfide as acceptor",
    "1.8.5.-\tWith a quinone or similar compound as acceptor",
    "1.8.5.n\tWith a quinone or similar compound as acceptor",
    "1.8.6.-\tWith an nitrogenous group as acceptor",
    "1.8.6.n\tWith an nitrogenous group as acceptor",
    "1.8.7.-\tWith an iron-sulfur protein as acceptor",
    "1.8.7.n\tWith an iron-sulfur protein as acceptor",
    "1.8.98.-\tWith other, known, acceptors",
    "1.8.98.n\tWith other, known, acceptors",
    "1.8.99.-\tWith other acceptors",
    "1.8.99.n\tWith other acceptors",
    "1.9.-.-\tActing on a heme group of donors",
    "1.9.n.n\tActing on a heme group of donors",
    "1.9.3.-\tWith oxygen as acceptor",
    "1.9.3.n\tWith oxygen as acceptor",
    "1.9.6.-\tWith a nitrogenous group as acceptor",
    "1.9.6.n\tWith a nitrogenous group as acceptor",
    "1.9.98.-\tWith other, known, acceptors",
    "1.9.98.n\tWith other, known, acceptors",
    "1.9.99.-\tWith other acceptors",
    "1.9.99.n\tWith other acceptors",
    "1.10.-.-\tActing on diphenols and related substances as donors",
    "1.10.n.n\tActing on diphenols and related substances as donors",
    "1.10.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.10.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.10.2.-\tWith a cytochrome as acceptor",
    "1.10.2.n\tWith a cytochrome as acceptor",
    "1.10.3.-\tWith oxygen as acceptor",
    "1.10.3.n\tWith oxygen as acceptor",
    "1.10.5.-\tWith a quinone or related compound as acceptor",
    "1.10.5.n\tWith a quinone or related compound as acceptor",
    "1.10.9.-\tWith a copper protein as acceptor",
    "1.10.9.n\tWith a copper protein as acceptor",
    "1.10.98.-\tWith other, known, acceptors",
    "1.10.98.n\tWith other, known, acceptors",
    "1.10.99.-\tWith other acceptors",
    "1.10.99.n\tWith other acceptors",
    "1.11.-.-\tActing on a peroxide as acceptor",
    "1.11.n.n\tActing on a peroxide as acceptor",
    "1.11.1.-\tPeroxidases",
    "1.11.1.n\tPeroxidases",
    "1.11.2.-\tWith H2O2 as acceptor, one oxygen atom of which is incorporated into the product",
    "1.11.2.n\tWith H2O2 as acceptor, one oxygen atom of which is incorporated into the product",
    "1.12.-.-\tActing on hydrogen as donors",
    "1.12.n.n\tActing on hydrogen as donors",
    "1.12.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.12.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.12.2.-\tWith a cytochrome as acceptor",
    "1.12.2.n\tWith a cytochrome as acceptor",
    "1.12.5.-\tWith a quinone or similar compound as acceptor",
    "1.12.5.n\tWith a quinone or similar compound as acceptor",
    "1.12.7.-\tWith an iron-sulfur protein as acceptor",
    "1.12.7.n\tWith an iron-sulfur protein as acceptor",
    "1.12.98.-\tWith other, known, acceptors",
    "1.12.98.n\tWith other, known, acceptors",
    "1.12.99.-\tWith other acceptors",
    "1.12.99.n\tWith other acceptors",
    "1.13.-.-\tActing on single donors with incorporation of molecular oxygen (oxygenases). The oxygen incorporated need not be derived from O2",
    "1.13.n.n\tActing on single donors with incorporation of molecular oxygen (oxygenases). The oxygen incorporated need not be derived from O2",
    "1.13.1.-\tWith NADH or NADPH as one donor",
    "1.13.1.n\tWith NADH or NADPH as one donor",
    "1.13.11.-\tWith incorporation of two atoms of oxygen",
    "1.13.11.n\tWith incorporation of two atoms of oxygen",
    "1.13.12.-\tWith incorporation of one atom of oxygen (internal monooxygenases or internal mixed function oxidases)",
    "1.13.12.n\tWith incorporation of one atom of oxygen (internal monooxygenases or internal mixed function oxidases)",
    "1.13.99.-\tMiscellaneous",
    "1.13.99.n\tMiscellaneous",
    "1.14.-.-\tActing on paired donors, with incorporation or reduction of molecular oxygen. The oxygen incorporated need not be derived from O2",
    "1.14.n.n\tActing on paired donors, with incorporation or reduction of molecular oxygen. The oxygen incorporated need not be derived from O2",
    "1.14.1.-\tWith NADH or NADPH as one donor",
    "1.14.1.n\tWith NADH or NADPH as one donor",
    "1.14.2.-\tWith ascorbate as one donor",
    "1.14.2.n\tWith ascorbate as one donor",
    "1.14.3.-\tWith reduced pteridine as one donor",
    "1.14.3.n\tWith reduced pteridine as one donor",
    "1.14.11.-\tWith 2-oxoglutarate as one donor, and incorporation of one atom each of oxygen into both donors",
    "1.14.11.n\tWith 2-oxoglutarate as one donor, and incorporation of one atom each of oxygen into both donors",
    "1.14.12.-\tWith NADH or NADPH as one donor, and incorporation of two atoms of oxygen into one donor",
    "1.14.12.n\tWith NADH or NADPH as one donor, and incorporation of two atoms of oxygen into one donor",
    "1.14.13.-\tWith NADH or NADPH as one donor, and incorporation of one atom of oxygen",
    "1.14.13.n\tWith NADH or NADPH as one donor, and incorporation of one atom of oxygen",
    "1.14.14.-\tWith reduced flavin or flavoprotein as one donor, and incorporation of one atom of oxygen",
    "1.14.14.n\tWith reduced flavin or flavoprotein as one donor, and incorporation of one atom of oxygen",
    "1.14.15.-\tWith reduced iron-sulfur protein as one donor, and incorporation of one atom of oxygen",
    "1.14.15.n\tWith reduced iron-sulfur protein as one donor, and incorporation of one atom of oxygen",
    "1.14.16.-\tWith reduced pteridine as one donor, and incorporation of one atom of oxygen",
    "1.14.16.n\tWith reduced pteridine as one donor, and incorporation of one atom of oxygen",
    "1.14.17.-\tWith reduced ascorbate as one donor, and incorporation of one atom of oxygen",
    "1.14.17.n\tWith reduced ascorbate as one donor, and incorporation of one atom of oxygen",
    "1.14.18.-\tWith another compound as one donor, and incorporation of one atom of oxygen",
    "1.14.18.n\tWith another compound as one donor, and incorporation of one atom of oxygen",
    "1.14.19.-\tWith oxidation of a pair of donors resulting in the reduction of molecular oxygen to two molecules of water",
    "1.14.19.n\tWith oxidation of a pair of donors resulting in the reduction of molecular oxygen to two molecules of water",
    "1.14.20.-\tWith 2-oxoglutarate as one donor, and the other dehydrogenated",
    "1.14.20.n\tWith 2-oxoglutarate as one donor, and the other dehydrogenated",
    "1.14.21.-\tWith NADH or NADPH as one donor, and the other dehydrogenated",
    "1.14.21.n\tWith NADH or NADPH as one donor, and the other dehydrogenated",
    "1.14.99.-\tMiscellaneous",
    "1.14.99.n\tMiscellaneous",
    "1.15.-.-\tActing on superoxide as acceptor",
    "1.15.n.n\tActing on superoxide as acceptor",
    "1.15.1.-\tActing on superoxide as acceptor",
    "1.15.1.n\tActing on superoxide as acceptor",
    "1.16.-.-\tOxidizing metal ions",
    "1.16.n.n\tOxidizing metal ions",
    "1.16.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.16.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.16.3.-\tWith oxygen as acceptor",
    "1.16.3.n\tWith oxygen as acceptor",
    "1.16.5.-\tWith a quinone or similar compound as acceptor",
    "1.16.5.n\tWith a quinone or similar compound as acceptor",
    "1.16.8.-\tWith a flavin as acceptor",
    "1.16.8.n\tWith a flavin as acceptor",
    "1.16.9.-\tWith a copper protein as acceptor",
    "1.16.9.n\tWith a copper protein as acceptor",
    "1.16.98.-\tWith other known acceptors",
    "1.16.98.n\tWith other known acceptors",
    "1.16.99.-\tWith other acceptors",
    "1.16.99.n\tWith other acceptors",
    "1.17.-.-\tActing on CH or CH2 groups",
    "1.17.n.n\tActing on CH or CH2 groups",
    "1.17.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.17.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.17.2.-\tWith a cytochrome as acceptor",
    "1.17.2.n\tWith a cytochrome as acceptor",
    "1.17.3.-\tWith oxygen as acceptor",
    "1.17.3.n\tWith oxygen as acceptor",
    "1.17.4.-\tWith a disulfide as acceptor",
    "1.17.4.n\tWith a disulfide as acceptor",
    "1.17.5.-\tWith a quinone or similar compound as acceptor",
    "1.17.5.n\tWith a quinone or similar compound as acceptor",
    "1.17.7.-\tWith an iron-sulfur protein as acceptor",
    "1.17.7.n\tWith an iron-sulfur protein as acceptor",
    "1.17.8.-\tWith a flavin as acceptor",
    "1.17.8.n\tWith a flavin as acceptor",
    "1.17.9.-\tWith a copper protein as acceptor",
    "1.17.9.n\tWith a copper protein as acceptor",
    "1.17.98.-\tWith other, known, acceptors",
    "1.17.98.n\tWith other, known, acceptors",
    "1.17.99.-\tWith other acceptors",
    "1.17.99.n\tWith other acceptors",
    "1.18.-.-\tActing on iron-sulfur proteins as donors",
    "1.18.n.n\tActing on iron-sulfur proteins as donors",
    "1.18.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.18.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.18.2.-\tWith dinitrogen as acceptor",
    "1.18.2.n\tWith dinitrogen as acceptor",
    "1.18.3.-\tWith H(+) as acceptor",
    "1.18.3.n\tWith H(+) as acceptor",
    "1.18.6.-\tWith dinitrogen as acceptor",
    "1.18.6.n\tWith dinitrogen as acceptor",
    "1.18.96.-\tWith other, known, acceptors",
    "1.18.96.n\tWith other, known, acceptors",
    "1.18.99.-\tWith H(+) as acceptor",
    "1.18.99.n\tWith H(+) as acceptor",
    "1.19.-.-\tActing on reduced flavodoxin as donor",
    "1.19.n.n\tActing on reduced flavodoxin as donor",
    "1.19.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.19.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.19.6.-\tWith dinitrogen as acceptor",
    "1.19.6.n\tWith dinitrogen as acceptor",
    "1.20.-.-\tActing on phosphorus or arsenic in donors",
    "1.20.n.n\tActing on phosphorus or arsenic in donors",
    "1.20.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.20.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.20.2.-\tWith a cytochrome as acceptor",
    "1.20.2.n\tWith a cytochrome as acceptor",
    "1.20.4.-\tWith disulfide as acceptor",
    "1.20.4.n\tWith disulfide as acceptor",
    "1.20.9.-\tWith a copper protein as acceptor",
    "1.20.9.n\tWith a copper protein as acceptor",
    "1.20.98.-\tWith other, known acceptors",
    "1.20.98.n\tWith other, known acceptors",
    "1.20.99.-\tWith other acceptors",
    "1.20.99.n\tWith other acceptors",
    "1.21.-.-\tCatalyzing the reaction X-H + Y-H = 'X-Y'",
    "1.21.n.n\tCatalyzing the reaction X-H + Y-H = 'X-Y'",
    "1.21.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.21.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.21.3.-\tWith oxygen as acceptor",
    "1.21.3.n\tWith oxygen as acceptor",
    "1.21.4.-\tWith a disulfide as acceptor",
    "1.21.4.n\tWith a disulfide as acceptor",
    "1.21.98.-\tWith other, known acceptors",
    "1.21.98.n\tWith other, known acceptors",
    "1.21.99.-\tWith other acceptors",
    "1.21.99.n\tWith other acceptors",
    "1.22.-.-\tActing on halogen in donors",
    "1.22.n.n\tActing on halogen in donors",
    "1.22.1.-\tWith NAD(+) or NADP(+) as acceptor",
    "1.22.1.n\tWith NAD(+) or NADP(+) as acceptor",
    "1.23.-.-\tReducing C-O-C group as acceptor",
    "1.23.n.n\tReducing C-O-C group as acceptor",
    "1.23.1.-\tWith NADH or NADPH as donor",
    "1.23.1.n\tWith NADH or NADPH as donor",
    "1.23.5.-\tWith a quinone or similar compound as acceptor",
    "1.23.5.n\tWith a quinone or similar compound as acceptor",
    "1.97.-.-\tOther oxidoreductases",
    "1.97.n.n\tOther oxidoreductases",
    "1.97.1.-\tOther oxidoreductases",
    "1.97.1.n\tOther oxidoreductases",
    "1.98.-.-\tEnzymes using H2 as reductant",
    "1.98.n.n\tEnzymes using H2 as reductant",
    "1.98.1.-\tOther oxidoreductases",
    "1.98.1.n\tOther oxidoreductases",
    "1.99.-.-\tOther enzymes using O2 as oxidant",
    "1.99.n.n\tOther enzymes using O2 as oxidant",
    "1.99.1.-\tHydroxylases",
    "1.99.1.n\tHydroxylases",
    "1.99.2.-\tOxygenases",
    "1.99.2.n\tOxygenases",
    "2.-.-.-\tTransferases",
    "2.n.n.n\tTransferases",
    "2.1.-.-\tTransferring one-carbon groups",
    "2.1.n.n\tTransferring one-carbon groups",
    "2.1.1.-\tMethyltransferases",
    "2.1.1.n\tMethyltransferases",
    "2.1.2.-\tHydroxymethyl-, formyl- and related transferases",
    "2.1.2.n\tHydroxymethyl-, formyl- and related transferases",
    "2.1.3.-\tCarboxy- and carbamoyltransferases",
    "2.1.3.n\tCarboxy- and carbamoyltransferases",
    "2.1.4.-\tAmidinotransferases",
    "2.1.4.n\tAmidinotransferases",
    "2.1.5.-\tMethylenetransferases",
    "2.1.5.n\tMethylenetransferases",
    "2.2.-.-\tTransferring aldehyde or ketonic groups",
    "2.2.n.n\tTransferring aldehyde or ketonic groups",
    "2.2.1.-\tTransketolases and transaldolases",
    "2.2.1.n\tTransketolases and transaldolases",
    "2.3.-.-\tAcyltransferases",
    "2.3.n.n\tAcyltransferases",
    "2.3.1.-\tTransferring groups other than amino-acyl groups",
    "2.3.1.n\tTransferring groups other than amino-acyl groups",
    "2.3.2.-\tAminoacyltransferases",
    "2.3.2.n\tAminoacyltransferases",
    "2.3.3.-\tAcyl groups converted into alkyl groups on transfer",
    "2.3.3.n\tAcyl groups converted into alkyl groups on transfer",
    "2.4.-.-\tGlycosyltransferases",
    "2.4.n.n\tGlycosyltransferases",
    "2.4.1.-\tHexosyltransferases",
    "2.4.1.n\tHexosyltransferases",
    "2.4.2.-\tPentosyltransferases",
    "2.4.2.n\tPentosyltransferases",
    "2.4.3.-\tSialyltransferases",
    "2.4.3.n\tSialyltransferases",
    "2.4.99.-\tTransferring other glycosyl groups",
    "2.4.99.n\tTransferring other glycosyl groups",
    "2.5.-.-\tTransferring alkyl or aryl groups, other than methyl groups",
    "2.5.n.n\tTransferring alkyl or aryl groups, other than methyl groups",
    "2.5.1.-\tTransferring alkyl or aryl groups, other than methyl groups",
    "2.5.1.n\tTransferring alkyl or aryl groups, other than methyl groups",
    "2.6.-.-\tTransferring nitrogenous groups",
    "2.6.n.n\tTransferring nitrogenous groups",
    "2.6.1.-\tTransaminases",
    "2.6.1.n\tTransaminases",
    "2.6.2.-\tAmidinotransferases",
    "2.6.2.n\tAmidinotransferases",
    "2.6.3.-\tOximinotransferases",
    "2.6.3.n\tOximinotransferases",
    "2.6.99.-\tTransferring other nitrogenous groups",
    "2.6.99.n\tTransferring other nitrogenous groups",
    "2.7.-.-\tTransferring phosphorus-containing groups",
    "2.7.n.n\tTransferring phosphorus-containing groups",
    "2.7.1.-\tPhosphotransferases with an alcohol group as acceptor",
    "2.7.1.n\tPhosphotransferases with an alcohol group as acceptor",
    "2.7.2.-\tPhosphotransferases with a carboxy group as acceptor",
    "2.7.2.n\tPhosphotransferases with a carboxy group as acceptor",
    "2.7.3.-\tPhosphotransferases with a nitrogenous group as acceptor",
    "2.7.3.n\tPhosphotransferases with a nitrogenous group as acceptor",
    "2.7.4.-\tPhosphotransferases with a phosphate group as acceptor",
    "2.7.4.n\tPhosphotransferases with a phosphate group as acceptor",
    "2.7.5.-\tPhosphotransferases with regeneration of donors, apparently catalyzing intramolecular transfers",
    "2.7.5.n\tPhosphotransferases with regeneration of donors, apparently catalyzing intramolecular transfers",
    "2.7.6.-\tDiphosphotransferases",
    "2.7.6.n\tDiphosphotransferases",
    "2.7.7.-\tNucleotidyltransferases",
    "2.7.7.n\tNucleotidyltransferases",
    "2.7.8.-\tTransferases for other substituted phosphate groups",
    "2.7.8.n\tTransferases for other substituted phosphate groups",
    "2.7.9.-\tPhosphotransferases with paired acceptors",
    "2.7.9.n\tPhosphotransferases with paired acceptors",
    "2.7.10.-\tProtein-tyrosine kinases",
    "2.7.10.n\tProtein-tyrosine kinases",
    "2.7.11.-\tProtein-serine/threonine kinases",
    "2.7.11.n\tProtein-serine/threonine kinases",
    "2.7.12.-\tDual-specificity kinases (those acting on Ser/Thr and Tyr residues)",
    "2.7.12.n\tDual-specificity kinases (those acting on Ser/Thr and Tyr residues)",
    "2.7.13.-\tProtein-histidine kinases",
    "2.7.13.n\tProtein-histidine kinases",
    "2.7.14.-\tProtein-arginine kinases",
    "2.7.14.n\tProtein-arginine kinases",
    "2.7.99.-\tOther protein kinases",
    "2.7.99.n\tOther protein kinases",
    "2.8.-.-\tTransferring sulfur-containing groups",
    "2.8.n.n\tTransferring sulfur-containing groups",
    "2.8.1.-\tSulfurtransferases",
    "2.8.1.n\tSulfurtransferases",
    "2.8.2.-\tSulfotransferases",
    "2.8.2.n\tSulfotransferases",
    "2.8.3.-\tCoA-transferases",
    "2.8.3.n\tCoA-transferases",
    "2.8.4.-\tTransferring alkylthio groups",
    "2.8.4.n\tTransferring alkylthio groups",
    "2.8.5.-\tThiosulfotransferases",
    "2.8.5.n\tThiosulfotransferases",
    "2.9.-.-\tTransferring selenium-containing groups",
    "2.9.n.n\tTransferring selenium-containing groups",
    "2.9.1.-\tSelenotransferases",
    "2.9.1.n\tSelenotransferases",
    "2.10.-.-\tTransferring molybdenum- or tungsten-containing groups",
    "2.10.n.n\tTransferring molybdenum- or tungsten-containing groups",
    "2.10.1.-\tMolybdenumtransferases or tungstentransferases with sulfide groups as acceptors",
    "2.10.1.n\tMolybdenumtransferases or tungstentransferases with sulfide groups as acceptors",
    "3.-.-.-\tHydrolases",
    "3.n.n.n\tHydrolases",
    "3.1.-.-\tActing on ester bonds",
    "3.1.n.n\tActing on ester bonds",
    "3.1.1.-\tCarboxylic ester hydrolases",
    "3.1.1.n\tCarboxylic ester hydrolases",
    "3.1.2.-\tThiolester hydrolases",
    "3.1.2.n\tThiolester hydrolases",
    "3.1.3.-\tPhosphoric monoester hydrolases",
    "3.1.3.n\tPhosphoric monoester hydrolases",
    "3.1.4.-\tPhosphoric diester hydrolases",
    "3.1.4.n\tPhosphoric diester hydrolases",
    "3.1.5.-\tTriphosphoric monoester hydrolases",
    "3.1.5.n\tTriphosphoric monoester hydrolases",
    "3.1.6.-\tSulfuric ester hydrolases",
    "3.1.6.n\tSulfuric ester hydrolases",
    "3.1.7.-\tDiphosphoric monoester hydrolases",
    "3.1.7.n\tDiphosphoric monoester hydrolases",
    "3.1.8.-\tPhosphoric triester hydrolases",
    "3.1.8.n\tPhosphoric triester hydrolases",
    "3.1.11.-\tExodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.11.n\tExodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.12.-\tExodeoxyribonucleases producing 3'-phosphomonoesters",
    "3.1.12.n\tExodeoxyribonucleases producing 3'-phosphomonoesters",
    "3.1.13.-\tExoribonucleases producing 5'-phosphomonoesters",
    "3.1.13.n\tExoribonucleases producing 5'-phosphomonoesters",
    "3.1.14.-\tExoribonucleases producing 3'-phosphomonoesters",
    "3.1.14.n\tExoribonucleases producing 3'-phosphomonoesters",
    "3.1.15.-\tExonucleases active with either ribo- or deoxyribonucleic acids and producing 5'-phosphomonoesters",
    "3.1.15.n\tExonucleases active with either ribo- or deoxyribonucleic acids and producing 5'-phosphomonoesters",
    "3.1.16.-\tExonucleases active with either ribo- or deoxyribonucleic acids and producing 3'-phosphomonoesters",
    "3.1.16.n\tExonucleases active with either ribo- or deoxyribonucleic acids and producing 3'-phosphomonoesters",
    "3.1.21.-\tEndodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.21.n\tEndodeoxyribonucleases producing 5'-phosphomonoesters",
    "3.1.22.-\tEndodeoxyribonucleases producing other than 5'-phosphomonoesters",
    "3.1.22.n\tEndodeoxyribonucleases producing other than 5'-phosphomonoesters",
    "3.1.23.-\tSite specific endodeoxyribonucleases: cleavage is sequence specific",
    "3.1.23.n\tSite specific endodeoxyribonucleases: cleavage is sequence specific",
    "3.1.24.-\tSite specific endodeoxyribonucleases: cleavage is not sequence specific",
    "3.1.24.n\tSite specific endodeoxyribonucleases: cleavage is not sequence specific",
    "3.1.25.-\tSite-specific endodeoxyribonucleases specific for altered bases",
    "3.1.25.n\tSite-specific endodeoxyribonucleases specific for altered bases",
    "3.1.26.-\tEndoribonucleases producing 5'-phosphomonoesters",
    "3.1.26.n\tEndoribonucleases producing 5'-phosphomonoesters",
    "3.1.27.-\tEndoribonucleases producing other than 5'-phosphomonoesters",
    "3.1.27.n\tEndoribonucleases producing other than 5'-phosphomonoesters",
    "3.1.30.-\tEndoribonucleases active with either ribo- or deoxyribonucleic acids and producing 5'-phosphomonoesters",
    "3.1.30.n\tEndoribonucleases active with either ribo- or deoxyribonucleic acids and producing 5'-phosphomonoesters",
    "3.1.31.-\tEndoribonucleases active with either ribo- or deoxyribonucleic acids and producing 3'-phosphomonoesters",
    "3.1.31.n\tEndoribonucleases active with either ribo- or deoxyribonucleic acids and producing 3'-phosphomonoesters",
    "3.2.-.-\tGlycosylases",
    "3.2.n.n\tGlycosylases",
    "3.2.1.-\tGlycosidases, i.e. enzymes hydrolyzing O- and S-glycosyl compounds",
    "3.2.1.n\tGlycosidases, i.e. enzymes hydrolyzing O- and S-glycosyl compounds",
    "3.2.2.-\tHydrolyzing N-glycosyl compounds",
    "3.2.2.n\tHydrolyzing N-glycosyl compounds",
    "3.2.3.-\tHydrolyzing S-glycosyl compounds",
    "3.2.3.n\tHydrolyzing S-glycosyl compounds",
    "3.3.-.-\tActing on ether bonds",
    "3.3.n.n\tActing on ether bonds",
    "3.3.1.-\tThioether and trialkylsulfonium hydrolases",
    "3.3.1.n\tThioether and trialkylsulfonium hydrolases",
    "3.3.2.-\tEther hydrolases",
    "3.3.2.n\tEther hydrolases",
    "3.4.-.-\tActing on peptide bonds (peptidases)",
    "3.4.n.n\tActing on peptide bonds (peptidases)",
    "3.4.1.-\talpha-Amino-acyl-peptide hydrolases",
    "3.4.1.n\talpha-Amino-acyl-peptide hydrolases",
    "3.4.2.-\tPeptidyl-amino-acid hydrolases",
    "3.4.2.n\tPeptidyl-amino-acid hydrolases",
    "3.4.3.-\tDipeptide hydrolases",
    "3.4.3.n\tDipeptide hydrolases",
    "3.4.4.-\tPeptidyl peptide hydrolases",
    "3.4.4.n\tPeptidyl peptide hydrolases",
    "3.4.11.-\tAminopeptidases",
    "3.4.11.n\tAminopeptidases",
    "3.4.12.-\tPeptidylamino-acid hydrolases or acylamino-acid hydrolases",
    "3.4.12.n\tPeptidylamino-acid hydrolases or acylamino-acid hydrolases",
    "3.4.13.-\tDipeptidases",
    "3.4.13.n\tDipeptidases",
    "3.4.14.-\tDipeptidyl-peptidases and tripeptidyl-peptidases",
    "3.4.14.n\tDipeptidyl-peptidases and tripeptidyl-peptidases",
    "3.4.15.-\tPeptidyl-dipeptidases",
    "3.4.15.n\tPeptidyl-dipeptidases",
    "3.4.16.-\tSerine-type carboxypeptidases",
    "3.4.16.n\tSerine-type carboxypeptidases",
    "3.4.17.-\tMetallocarboxypeptidases",
    "3.4.17.n\tMetallocarboxypeptidases",
    "3.4.18.-\tCysteine-type carboxypeptidases",
    "3.4.18.n\tCysteine-type carboxypeptidases",
    "3.4.19.-\tOmega peptidases",
    "3.4.19.n\tOmega peptidases",
    "3.4.21.-\tSerine endopeptidases",
    "3.4.21.n\tSerine endopeptidases",
    "3.4.22.-\tCysteine endopeptidases",
    "3.4.22.n\tCysteine endopeptidases",
    "3.4.23.-\tAspartic endopeptidases",
    "3.4.23.n\tAspartic endopeptidases",
    "3.4.24.-\tMetalloendopeptidases",
    "3.4.24.n\tMetalloendopeptidases",
    "3.4.25.-\tThreonine endopeptidases",
    "3.4.25.n\tThreonine endopeptidases",
    "3.4.99.-\tEndopeptidases of unknown catalytic mechanism",
    "3.4.99.n\tEndopeptidases of unknown catalytic mechanism",
    "3.5.-.-\tActing on carbon-nitrogen bonds, other than peptide bonds",
    "3.5.n.n\tActing on carbon-nitrogen bonds, other than peptide bonds",
    "3.5.1.-\tIn linear amides",
    "3.5.1.n\tIn linear amides",
    "3.5.2.-\tIn cyclic amides",
    "3.5.2.n\tIn cyclic amides",
    "3.5.3.-\tIn linear amidines",
    "3.5.3.n\tIn linear amidines",
    "3.5.4.-\tIn cyclic amidines",
    "3.5.4.n\tIn cyclic amidines",
    "3.5.5.-\tIn nitriles",
    "3.5.5.n\tIn nitriles",
    "3.5.99.-\tIn other compounds",
    "3.5.99.n\tIn other compounds",
    "3.6.-.-\tActing on acid anhydrides",
    "3.6.n.n\tActing on acid anhydrides",
    "3.6.1.-\tIn phosphorus-containing anhydrides",
    "3.6.1.n\tIn phosphorus-containing anhydrides",
    "3.6.2.-\tIn sulfonyl-containing anhydrides",
    "3.6.2.n\tIn sulfonyl-containing anhydrides",
    "3.6.3.-\tActing on acid anhydrides; catalyzing transmembrane movement of substances",
    "3.6.3.n\tActing on acid anhydrides; catalyzing transmembrane movement of substances",
    "3.6.4.-\tActing on ATP; involved in cellular and subcellular movement",
    "3.6.4.n\tActing on ATP; involved in cellular and subcellular movement",
    "3.6.5.-\tActing on GTP; involved in cellular and subcellular movement",
    "3.6.5.n\tActing on GTP; involved in cellular and subcellular movement",
    "3.7.-.-\tActing on carbon-carbon bonds",
    "3.7.n.n\tActing on carbon-carbon bonds",
    "3.7.1.-\tIn ketonic substances",
    "3.7.1.n\tIn ketonic substances",
    "3.8.-.-\tActing on halide bonds",
    "3.8.n.n\tActing on halide bonds",
    "3.8.1.-\tIn C-halide compounds",
    "3.8.1.n\tIn C-halide compounds",
    "3.8.2.-\tIn P-halide compounds",
    "3.8.2.n\tIn P-halide compounds",
    "3.9.-.-\tActing on phosphorus-nitrogen bonds",
    "3.9.n.n\tActing on phosphorus-nitrogen bonds",
    "3.9.1.-\tActing on phosphorus-nitrogen bonds",
    "3.9.1.n\tActing on phosphorus-nitrogen bonds",
    "3.10.-.-\tActing on sulfur-nitrogen bonds",
    "3.10.n.n\tActing on sulfur-nitrogen bonds",
    "3.10.1.-\tActing on sulfur-nitrogen bonds",
    "3.10.1.n\tActing on sulfur-nitrogen bonds",
    "3.11.-.-\tActing on carbon-phosphorus bonds",
    "3.11.n.n\tActing on carbon-phosphorus bonds",
    "3.11.1.-\tActing on carbon-phosphorus bonds",
    "3.11.1.n\tActing on carbon-phosphorus bonds",
    "3.12.-.-\tActing on sulfur-sulfur bonds",
    "3.12.n.n\tActing on sulfur-sulfur bonds",
    "3.12.1.-\tActing on sulfur-sulfur bonds",
    "3.12.1.n\tActing on sulfur-sulfur bonds",
    "3.13.-.-\tActing on carbon-sulfur bonds",
    "3.13.n.n\tActing on carbon-sulfur bonds",
    "3.13.1.-\tActing on carbon-sulfur bonds",
    "3.13.1.n\tActing on carbon-sulfur bonds",
    "3.13.2.-\tThioether and trialkylsulfonium hydrolases",
    "3.13.2.n\tThioether and trialkylsulfonium hydrolases",
    "4.-.-.-\tLyases",
    "4.n.n.n\tLyases",
    "4.1.-.-\tCarbon-carbon lyases",
    "4.1.n.n\tCarbon-carbon lyases",
    "4.1.1.-\tCarboxy-lyases",
    "4.1.1.n\tCarboxy-lyases",
    "4.1.2.-\tAldehyde-lyases",
    "4.1.2.n\tAldehyde-lyases",
    "4.1.3.-\tOxo-acid-lyases",
    "4.1.3.n\tOxo-acid-lyases",
    "4.1.99.-\tOther carbon-carbon lyases",
    "4.1.99.n\tOther carbon-carbon lyases",
    "4.2.-.-\tCarbon-oxygen lyases",
    "4.2.n.n\tCarbon-oxygen lyases",
    "4.2.1.-\tHydro-lyases",
    "4.2.1.n\tHydro-lyases",
    "4.2.2.-\tActing on polysaccharides",
    "4.2.2.n\tActing on polysaccharides",
    "4.2.3.-\tActing on phosphates",
    "4.2.3.n\tActing on phosphates",
    "4.2.99.-\tOther carbon-oxygen lyases",
    "4.2.99.n\tOther carbon-oxygen lyases",
    "4.3.-.-\tCarbon-nitrogen lyases",
    "4.3.n.n\tCarbon-nitrogen lyases",
    "4.3.1.-\tAmmonia-lyases",
    "4.3.1.n\tAmmonia-lyases",
    "4.3.2.-\tLyases acting on amides, amidines, etc",
    "4.3.2.n\tLyases acting on amides, amidines, etc",
    "4.3.3.-\tAmine-lyases",
    "4.3.3.n\tAmine-lyases",
    "4.3.99.-\tOther carbon-nitrogen lyases",
    "4.3.99.n\tOther carbon-nitrogen lyases",
    "4.4.-.-\tCarbon-sulfur lyases",
    "4.4.n.n\tCarbon-sulfur lyases",
    "4.4.1.-\tCarbon-sulfur lyases",
    "4.4.1.n\tCarbon-sulfur lyases",
    "4.5.-.-\tCarbon-halide lyases",
    "4.5.n.n\tCarbon-halide lyases",
    "4.5.1.-\tCarbon-halide lyases",
    "4.5.1.n\tCarbon-halide lyases",
    "4.6.-.-\tPhosphorus-oxygen lyases",
    "4.6.n.n\tPhosphorus-oxygen lyases",
    "4.6.1.-\tPhosphorus-oxygen lyases",
    "4.6.1.n\tPhosphorus-oxygen lyases",
    "4.7.-.-\tCarbon-phosphorus lyases",
    "4.7.n.n\tCarbon-phosphorus lyases",
    "4.7.1.-\tCarbon-phosphorus lyases",
    "4.7.1.n\tCarbon-phosphorus lyases",
    "4.8.-.-\tNitrogen-oxygen lyases",
    "4.8.n.n\tNitrogen-oxygen lyases",
    "4.8.1.-\tHydro-lyases",
    "4.8.1.n\tHydro-lyases",
    "4.98.-.-\tATP-independent chelatases",
    "4.98.n.n\tATP-independent chelatases",
    "4.98.1.-\tForming coordination complexes",
    "4.98.1.n\tForming coordination complexes",
    "4.99.-.-\tOther lyases",
    "4.99.n.n\tOther lyases",
    "4.99.1.-\tOther lyases",
    "4.99.1.n\tOther lyases",
    "5.-.-.-\tIsomerases",
    "5.n.n.n\tIsomerases",
    "5.1.-.-\tRacemases and epimerases",
    "5.1.n.n\tRacemases and epimerases",
    "5.1.1.-\tActing on amino acids and derivatives",
    "5.1.1.n\tActing on amino acids and derivatives",
    "5.1.2.-\tActing on hydroxy acids and derivatives",
    "5.1.2.n\tActing on hydroxy acids and derivatives",
    "5.1.3.-\tActing on carbohydrates and derivatives",
    "5.1.3.n\tActing on carbohydrates and derivatives",
    "5.1.99.-\tActing on other compounds",
    "5.1.99.n\tActing on other compounds",
    "5.2.-.-\tCis-trans-isomerases",
    "5.2.n.n\tCis-trans-isomerases",
    "5.2.1.-\tCis-trans isomerases",
    "5.2.1.n\tCis-trans isomerases",
    "5.3.-.-\tIntramolecular oxidoreductases",
    "5.3.n.n\tIntramolecular oxidoreductases",
    "5.3.1.-\tInterconverting aldoses and ketoses",
    "5.3.1.n\tInterconverting aldoses and ketoses",
    "5.3.2.-\tInterconverting keto- and enol-groups",
    "5.3.2.n\tInterconverting keto- and enol-groups",
    "5.3.3.-\tTransposing C=C bonds",
    "5.3.3.n\tTransposing C=C bonds",
    "5.3.4.-\tTransposing S-S bonds",
    "5.3.4.n\tTransposing S-S bonds",
    "5.3.99.-\tOther intramolecular oxidoreductases",
    "5.3.99.n\tOther intramolecular oxidoreductases",
    "5.4.-.-\tIntramolecular transferases",
    "5.4.n.n\tIntramolecular transferases",
    "5.4.1.-\tTransferring acyl groups",
    "5.4.1.n\tTransferring acyl groups",
    "5.4.2.-\tPhosphotransferases (phosphomutases)",
    "5.4.2.n\tPhosphotransferases (phosphomutases)",
    "5.4.3.-\tTransferring amino groups",
    "5.4.3.n\tTransferring amino groups",
    "5.4.4.-\tTransferring hydroxy groups",
    "5.4.4.n\tTransferring hydroxy groups",
    "5.4.99.-\tTransferring other groups",
    "5.4.99.n\tTransferring other groups",
    "5.5.-.-\tIntramolecular lyases",
    "5.5.n.n\tIntramolecular lyases",
    "5.5.1.-\tIntramolecular lyases",
    "5.5.1.n\tIntramolecular lyases",
    "5.6.-.-\tIsomerases altering macromolecular conformation",
    "5.6.n.n\tIsomerases altering macromolecular conformation",
    "5.6.1.-\tEnzymes altering polypeptide conformation or assembly",
    "5.6.1.n\tEnzymes altering polypeptide conformation or assembly",
    "5.6.2.-\tEnzymes altering nucleic acid conformation",
    "5.6.2.n\tEnzymes altering nucleic acid conformation",
    "5.99.-.-\tOther isomerases",
    "5.99.n.n\tOther isomerases",
    "5.99.1.-\tOther isomerases",
    "5.99.1.n\tOther isomerases",
    "6.-.-.-\tLigases",
    "6.n.n.n\tLigases",
    "6.1.-.-\tForming carbon-oxygen bonds",
    "6.1.n.n\tForming carbon-oxygen bonds",
    "6.1.1.-\tLigases forming aminoacyl-tRNA and related compounds",
    "6.1.1.n\tLigases forming aminoacyl-tRNA and related compounds",
    "6.1.2.-\tAcid--alcohol ligases (ester synthases)",
    "6.1.2.n\tAcid--alcohol ligases (ester synthases)",
    "6.1.3.-\tCyclo-ligases",
    "6.1.3.n\tCyclo-ligases",
    "6.2.-.-\tForming carbon-sulfur bonds",
    "6.2.n.n\tForming carbon-sulfur bonds",
    "6.2.1.-\tAcid--thiol ligases",
    "6.2.1.n\tAcid--thiol ligases",
    "6.2.2.-\tAmide--thiol ligases",
    "6.2.2.n\tAmide--thiol ligases",
    "6.3.-.-\tForming carbon-nitrogen bonds",
    "6.3.n.n\tForming carbon-nitrogen bonds",
    "6.3.1.-\tAcid--ammonia (or amine) ligases (amide synthases)",
    "6.3.1.n\tAcid--ammonia (or amine) ligases (amide synthases)",
    "6.3.2.-\tAcid--amino-acid ligases (peptide synthases)",
    "6.3.2.n\tAcid--amino-acid ligases (peptide synthases)",
    "6.3.3.-\tCyclo-ligases",
    "6.3.3.n\tCyclo-ligases",
    "6.3.4.-\tOther carbon--nitrogen ligases",
    "6.3.4.n\tOther carbon--nitrogen ligases",
    "6.3.5.-\tCarbon--nitrogen ligases with glutamine as amido-N-donor",
    "6.3.5.n\tCarbon--nitrogen ligases with glutamine as amido-N-donor",
    "6.4.-.-\tForming carbon-carbon bonds",
    "6.4.n.n\tForming carbon-carbon bonds",
    "6.4.1.-\tForming carbon-carbon bonds",
    "6.4.1.n\tForming carbon-carbon bonds",
    "6.5.-.-\tForming phosphoric ester bonds",
    "6.5.n.n\tForming phosphoric ester bonds",
    "6.5.1.-\tForming phosphoric ester bonds",
    "6.5.1.n\tForming phosphoric ester bonds",
    "6.6.-.-\tForming nitrogen-metal bonds",
    "6.6.n.n\tForming nitrogen-metal bonds",
    "6.6.1.-\tForming coordination complexes",
    "6.6.1.n\tForming coordination complexes",
    "6.7.-.-\tForming nitrogen-nitrogen bonds",
    "6.7.n.n\tForming nitrogen-nitrogen bonds",
    "6.7.1.-\tForming diazo bonds",
    "6.7.1.n\tForming diazo bonds",
    "7.-.-.-\tTranslocases",
    "7.n.n.n\tTranslocases",
    "7.1.-.-\tCatalysing the translocation of hydrons",
    "7.1.n.n\tCatalysing the translocation of hydrons",
    "7.1.1.-\tHydron translocation or charge separation linked to oxidoreductase reactions",
    "7.1.1.n\tHydron translocation or charge separation linked to oxidoreductase reactions",
    "7.1.2.-\tHydron translocation linked to the hydrolysis of a nucleoside triphosphate",
    "7.1.2.n\tHydron translocation linked to the hydrolysis of a nucleoside triphosphate",
    "7.1.3.-\tHydron translocation linked to the hydrolysis of diphosphate",
    "7.1.3.n\tHydron translocation linked to the hydrolysis of diphosphate",
    "7.2.-.-\tCatalysing the translocation of inorganic cations",
    "7.2.n.n\tCatalysing the translocation of inorganic cations",
    "7.2.1.-\tLinked to oxidoreductase reactions",
    "7.2.1.n\tLinked to oxidoreductase reactions",
    "7.2.2.-\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.2.2.n\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.2.3.-\tLinked to the hydrolysis of diphosphate",
    "7.2.3.n\tLinked to the hydrolysis of diphosphate",
    "7.2.4.-\tLinked to decarboxylation",
    "7.2.4.n\tLinked to decarboxylation",
    "7.3.-.-\tCatalysing the translocation of inorganic anions and their chelates",
    "7.3.n.n\tCatalysing the translocation of inorganic anions and their chelates",
    "7.3.2.-\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.3.2.n\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.4.-.-\tCatalysing the translocation amino acids and peptides",
    "7.4.n.n\tCatalysing the translocation amino acids and peptides",
    "7.4.2.-\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.4.2.n\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.5.-.-\tCatalysing the translocation carbohydrates and their derivatives",
    "7.5.n.n\tCatalysing the translocation carbohydrates and their derivatives",
    "7.5.2.-\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.5.2.n\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.6.-.-\tCatalysing the translocation of other compounds",
    "7.6.n.n\tCatalysing the translocation of other compounds",
    "7.6.2.-\tLinked to the hydrolysis of a nucleoside triphosphate",
    "7.6.2.n\tLinked to the hydrolysis of a nucleoside triphosphate"
};
